/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.block.RopeLadderBlock;
import com.mrtrollnugnug.ropebridge.datamap.SlabMap;
import com.mrtrollnugnug.ropebridge.item.ItemBridgeBuilder;
import com.mrtrollnugnug.ropebridge.item.ItemLadderBuilder;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

public final class ContentHandler {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ropebridge");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ropebridge");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ropebridge");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"ropebridge");
    public static final DeferredBlock<RopeLadderBlock> oak_rope_ladder = ContentHandler.registerBlockWithItem("oak_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.OAK_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> birch_rope_ladder = ContentHandler.registerBlockWithItem("birch_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.BIRCH_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> jungle_rope_ladder = ContentHandler.registerBlockWithItem("jungle_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.JUNGLE_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> spruce_rope_ladder = ContentHandler.registerBlockWithItem("spruce_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.SPRUCE_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> acacia_rope_ladder = ContentHandler.registerBlockWithItem("acacia_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.ACACIA_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> cherry_rope_ladder = ContentHandler.registerBlockWithItem("cherry_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.CHERRY_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> dark_oak_rope_ladder = ContentHandler.registerBlockWithItem("dark_oak_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.DARK_OAK_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> mangrove_rope_ladder = ContentHandler.registerBlockWithItem("mangrove_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.MANGROVE_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> pale_oak_rope_ladder = ContentHandler.registerBlockWithItem("pale_oak_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.PALE_OAK_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> bamboo_rope_ladder = ContentHandler.registerBlockWithItem("bamboo_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.BAMBOO_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> crimson_rope_ladder = ContentHandler.registerBlockWithItem("crimson_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.CRIMSON_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeLadderBlock> warped_rope_ladder = ContentHandler.registerBlockWithItem("warped_rope_ladder", properties -> new RopeLadderBlock((BlockBehaviour.Properties)properties, () -> Blocks.WARPED_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER));
    public static final DeferredBlock<RopeBridgeBlock> oak_bridge = ContentHandler.registerBlockWithItem("oak_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.OAK_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> birch_bridge = ContentHandler.registerBlockWithItem("birch_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.BIRCH_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BIRCH_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> jungle_bridge = ContentHandler.registerBlockWithItem("jungle_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.JUNGLE_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> spruce_bridge = ContentHandler.registerBlockWithItem("spruce_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.SPRUCE_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> acacia_bridge = ContentHandler.registerBlockWithItem("acacia_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.ACACIA_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> cherry_bridge = ContentHandler.registerBlockWithItem("cherry_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.CHERRY_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> dark_oak_bridge = ContentHandler.registerBlockWithItem("dark_oak_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.DARK_OAK_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_OAK_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> mangrove_bridge = ContentHandler.registerBlockWithItem("mangrove_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.MANGROVE_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MANGROVE_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> pale_oak_bridge = ContentHandler.registerBlockWithItem("pale_oak_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.PALE_OAK_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PALE_OAK_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> bamboo_bridge = ContentHandler.registerBlockWithItem("bamboo_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.BAMBOO_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> crimson_bridge = ContentHandler.registerBlockWithItem("crimson_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.CRIMSON_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_SLAB).noOcclusion());
    public static final DeferredBlock<RopeBridgeBlock> warped_bridge = ContentHandler.registerBlockWithItem("warped_bridge", properties -> new RopeBridgeBlock((BlockBehaviour.Properties)properties, () -> Blocks.WARPED_SLAB), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_SLAB).noOcclusion());
    public static final DeferredItem<ItemBridgeBuilder> bridge_builder = ITEMS.registerItem("bridge_builder", ItemBridgeBuilder::new);
    public static final DeferredItem<ItemLadderBuilder> ladder_builder = ITEMS.registerItem("ladder_builder", ItemLadderBuilder::new);
    public static final DeferredItem<Item> rope = ITEMS.registerSimpleItem("rope");
    public static final DeferredItem<Item> bridge_builder_hook = ITEMS.registerSimpleItem("bridge_builder_hook");
    public static final DeferredItem<Item> bridge_builder_barrel = ITEMS.registerSimpleItem("bridge_builder_barrel");
    public static final DeferredItem<ItemBridgeBuilder> bridge_builder_handle = ITEMS.registerItem("bridge_builder_handle", ItemBridgeBuilder::new);
    public static final DeferredItem<Item> ladder_hook = ITEMS.registerSimpleItem("ladder_hook");
    public static final DeferredHolder<SoundEvent, SoundEvent> load = SOUND_EVENTS.register("load", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Constants.modLoc("load")));
    public static final DeferredHolder<SoundEvent, SoundEvent> swoosh = SOUND_EVENTS.register("swoosh", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Constants.modLoc("swoosh")));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)bridge_builder.get())).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.ropebridge.tab")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
    }).build());
    public static final DataMapType<Block, SlabMap> SLAB_MAP = DataMapType.builder((ResourceLocation)Constants.modLoc("slab_map"), (ResourceKey)Registries.BLOCK, SlabMap.CODEC).synced(SlabMap.CODEC, false).build();

    public static <T extends Block> DeferredBlock<T> registerBlockWithItem(String name, Function<BlockBehaviour.Properties, ? extends T> func, BlockBehaviour.Properties properties) {
        DeferredBlock reg = BLOCKS.registerBlock(name, func, properties);
        ITEMS.registerSimpleBlockItem((Holder)reg);
        return reg;
    }

    public static void register(RegisterDataMapTypesEvent event) {
        event.register(SLAB_MAP);
    }
}

