/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.datagen.client;

import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModLanguageProvider
extends LanguageProvider {
    public ModLanguageProvider(PackOutput packOutput) {
        super(packOutput, "ropebridge", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.ropebridge.tab", "Rope Bridge");
        this.addItem((Supplier)ContentHandler.bridge_builder, "Bridge Building Gun");
        this.addItem((Supplier)ContentHandler.bridge_builder_hook, "Bridge Building Gun Hook");
        this.addItem((Supplier)ContentHandler.bridge_builder_barrel, "Gun Barrel");
        this.addItem((Supplier)ContentHandler.bridge_builder_handle, "Gun Stock");
        this.addItem((Supplier)ContentHandler.rope, "Rope");
        this.addItem((Supplier)ContentHandler.ladder_hook, "Ladder Gun Hook");
        this.addItem((Supplier)ContentHandler.ladder_builder, "Ladder Gun");
        this.addBlock((Supplier)ContentHandler.oak_bridge, "Oak Rope Bridge");
        this.addBlock((Supplier)ContentHandler.birch_bridge, "Birch Rope Bridge");
        this.addBlock((Supplier)ContentHandler.jungle_bridge, "Jungle Rope Bridge");
        this.addBlock((Supplier)ContentHandler.spruce_bridge, "Spruce Rope Bridge");
        this.addBlock((Supplier)ContentHandler.acacia_bridge, "Acacia Rope Bridge");
        this.addBlock((Supplier)ContentHandler.cherry_bridge, "Cherry Rope Bridge");
        this.addBlock((Supplier)ContentHandler.dark_oak_bridge, "Dark Oak Rope Bridge");
        this.addBlock((Supplier)ContentHandler.mangrove_bridge, "Mangrove Rope Bridge");
        this.addBlock((Supplier)ContentHandler.bamboo_bridge, "Bamboo Rope Bridge");
        this.addBlock((Supplier)ContentHandler.crimson_bridge, "Crimson Rope Bridge");
        this.addBlock((Supplier)ContentHandler.warped_bridge, "Warped Rope Bridge");
        this.addBlock((Supplier)ContentHandler.oak_rope_ladder, "Oak Rope Ladder");
        this.addBlock((Supplier)ContentHandler.birch_rope_ladder, "Birch Rope Ladder");
        this.addBlock((Supplier)ContentHandler.jungle_rope_ladder, "Jungle Rope Ladder");
        this.addBlock((Supplier)ContentHandler.spruce_rope_ladder, "Spruce Rope Ladder");
        this.addBlock((Supplier)ContentHandler.acacia_rope_ladder, "Acacia Rope Ladder");
        this.addBlock((Supplier)ContentHandler.cherry_rope_ladder, "Cherry Rope Ladder");
        this.addBlock((Supplier)ContentHandler.dark_oak_rope_ladder, "Dark Oak Rope Ladder");
        this.addBlock((Supplier)ContentHandler.mangrove_rope_ladder, "Mangrove Rope Ladder");
        this.addBlock((Supplier)ContentHandler.bamboo_rope_ladder, "Bamboo Rope Ladder");
        this.addBlock((Supplier)ContentHandler.crimson_rope_ladder, "Crimson Rope Ladder");
        this.addBlock((Supplier)ContentHandler.warped_rope_ladder, "Warped Rope Ladder");
        this.addSubtitle(ContentHandler.load, "Loading Gun");
        this.addSubtitle(ContentHandler.swoosh, "Gun Swoosh");
        this.addAdvancement("root", "Rope Bridge", "Build bridges with ease!");
        this.addAdvancement("craft_bridge_builder", "Bridge Building Gun", "Craft a bridge building grappling gun with a bridge hook, barrel, and handle");
        this.addAdvancement("build_bridge", "Rope Bridge", "Build a rope bridge with your new Bridge Building Gun");
        this.addAdvancement("craft_ladder_builder", "Ladder Building Gun", "Craft a ladder building grappling gun with a ladder hook, barrel, and handle");
        this.addAdvancement("build_ladder", "Rope Ladder", "Build a rope ladder with your new Ladder Gun");
        this.add("chat.ropebridge.warning.breaking", "WARNING! Breaking whole bridge!");
        this.add("chat.ropebridge.info.notonground", "You must be standing on something to build a bridge!");
        this.add("chat.ropebridge.info.notcardinal", "Sorry, bridge must be built in a cardinal direction. Please try again.");
        this.add("chat.ropebridge.info.greatslope", "Sorry, your slope is too great. Please try again.");
        this.add("chat.ropebridge.info.obstruction", "Oops! Looks like there's something in the way.");
        this.add("chat.ropebridge.info.underfunded_bridge", "You need at least %f slabs and %f rope to build this bridge.");
        this.add("chat.ropebridge.info.underfunded_ladder", "You need at least %f slabs and %f rope to build this ladder.");
        this.add("chat.ropebridge.info.bad_side", "You can't build a ladder on the %f of a block. Try the sides!");
        this.add("chat.ropebridge.info.not_solid", "That block can't support a rope ladder on that side.");
        this.add("chat.ropebridge.params.top", "top");
        this.add("chat.ropebridge.params.bottom", "bottom");
    }

    public void addSubtitle(DeferredHolder<SoundEvent, SoundEvent> sound, String text) {
        this.addSubtitle((SoundEvent)sound.get(), text);
    }

    public void addSubtitle(SoundEvent sound, String text) {
        String path = "ropebridge.subtitle." + sound.location().getPath();
        this.add(path, text);
    }

    private void addAdvancement(String id, String name, String description) {
        String prefix = "advancement.ropebridge.";
        this.add(prefix + id + ".title", name);
        this.add(prefix + id + ".desc", description);
    }
}

