/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.datagen.client;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.Condition;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class ModModelProvider
extends ModelProvider {
    public static final TextureSlot LOG = TextureSlot.create((String)"log");
    public static final TextureSlot PLANK = TextureSlot.create((String)"plank");
    public static final ModelTemplate BRIDGE_0 = ModelTemplates.create((String)"ropebridge:bridge_block_0", (TextureSlot[])new TextureSlot[]{LOG});
    public static final ModelTemplate BRIDGE_1 = ModelTemplates.create((String)"ropebridge:bridge_block_1", (TextureSlot[])new TextureSlot[]{LOG});
    public static final ModelTemplate BRIDGE_2 = ModelTemplates.create((String)"ropebridge:bridge_block_2", (TextureSlot[])new TextureSlot[]{LOG});
    public static final ModelTemplate BRIDGE_3 = ModelTemplates.create((String)"ropebridge:bridge_block_3", (TextureSlot[])new TextureSlot[]{LOG});
    public static final ModelTemplate ROPE_LADDER = ModelTemplates.create((String)"ropebridge:rope_ladder", (TextureSlot[])new TextureSlot[]{PLANK});

    public ModModelProvider(PackOutput output) {
        super(output, "ropebridge");
    }

    protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
        this.useExistingItem(itemModels, ContentHandler.bridge_builder);
        this.useExistingItem(itemModels, ContentHandler.ladder_builder);
        this.useExistingItem(itemModels, ContentHandler.rope);
        this.useExistingItem(itemModels, ContentHandler.bridge_builder_hook);
        this.useExistingItem(itemModels, ContentHandler.bridge_builder_barrel);
        this.useExistingItem(itemModels, ContentHandler.bridge_builder_handle);
        this.useExistingItem(itemModels, ContentHandler.ladder_hook);
        this.makeRopeLadder(blockModels, ContentHandler.oak_rope_ladder, "oak_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.birch_rope_ladder, "birch_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.jungle_rope_ladder, "jungle_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.spruce_rope_ladder, "spruce_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.acacia_rope_ladder, "acacia_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.cherry_rope_ladder, "cherry_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.dark_oak_rope_ladder, "dark_oak_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.mangrove_rope_ladder, "mangrove_log_top");
        this.makeRopeLadder(blockModels, ContentHandler.bamboo_rope_ladder, "bamboo_block_top");
        this.makeRopeLadder(blockModels, ContentHandler.crimson_rope_ladder, "crimson_stem_top");
        this.makeRopeLadder(blockModels, ContentHandler.warped_rope_ladder, "warped_stem_top");
        this.makeRopeBridge(blockModels, ContentHandler.oak_bridge, "oak_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.birch_bridge, "birch_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.jungle_bridge, "jungle_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.spruce_bridge, "spruce_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.acacia_bridge, "acacia_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.cherry_bridge, "cherry_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.dark_oak_bridge, "dark_oak_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.mangrove_bridge, "mangrove_log_top");
        this.makeRopeBridge(blockModels, ContentHandler.bamboo_bridge, "bamboo_block_top");
        this.makeRopeBridge(blockModels, ContentHandler.crimson_bridge, "crimson_stem_top");
        this.makeRopeBridge(blockModels, ContentHandler.warped_bridge, "warped_stem_top");
    }

    private void useExistingItem(ItemModelGenerators itemModels, DeferredItem<? extends Item> deferredItem) {
        itemModels.itemModelOutput.accept((Item)deferredItem.get(), ItemModelUtils.plainModel((ResourceLocation)Constants.modLoc("item/" + deferredItem.getId().getPath())));
    }

    private void makeRopeBridge(BlockModelGenerators blockModels, DeferredBlock<? extends Block> registryObject, String logTexture) {
        ResourceLocation logTextureLocation = ResourceLocation.withDefaultNamespace((String)("block/" + logTexture));
        ResourceLocation model0 = BRIDGE_0.createWithSuffix((Block)registryObject.get(), "_block_0", this.log(logTextureLocation), blockModels.modelOutput);
        ResourceLocation model1 = BRIDGE_1.createWithSuffix((Block)registryObject.get(), "_block_1", this.log(logTextureLocation), blockModels.modelOutput);
        ResourceLocation model2 = BRIDGE_2.createWithSuffix((Block)registryObject.get(), "_block_2", this.log(logTextureLocation), blockModels.modelOutput);
        ResourceLocation model3 = BRIDGE_3.createWithSuffix((Block)registryObject.get(), "_block_3", this.log(logTextureLocation), blockModels.modelOutput);
        blockModels.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)registryObject.get())).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(0)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)model0)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(1)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)model1)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(2)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)model2)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(3)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)model3)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(0)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)model0).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(1)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)model1).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(2)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)model2).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(3)).term((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)model3).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)));
        blockModels.registerSimpleItemModel(registryObject.asItem(), model0);
    }

    private TextureMapping log(ResourceLocation texture) {
        return new TextureMapping().put(LOG, texture);
    }

    private void makeRopeLadder(BlockModelGenerators blockModels, DeferredBlock<? extends Block> registryObject, String plankTexture) {
        ResourceLocation plankTextureLocation = ResourceLocation.withDefaultNamespace((String)("block/" + plankTexture));
        ResourceLocation model = ROPE_LADDER.create((Block)registryObject.get(), this.plank(plankTextureLocation), blockModels.modelOutput);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)registryObject.get()), (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)model)).with(BlockModelGenerators.createHorizontalFacingDispatchAlt()));
        blockModels.registerSimpleItemModel(registryObject.asItem(), model);
    }

    private TextureMapping plank(ResourceLocation texture) {
        return new TextureMapping().put(PLANK, texture);
    }
}

