/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.block;

import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;

public class RopeLadderBlock
extends LadderBlock {
    private final Supplier<Block> slabSupplier;

    public RopeLadderBlock(BlockBehaviour.Properties properties, Supplier<Block> slabSupplier) {
        super(properties);
        this.slabSupplier = slabSupplier;
    }

    public Block getSlab() {
        return this.slabSupplier.get();
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) && pLevel instanceof Level) {
            Level level = (Level)pLevel;
            if (!pLevel.getBlockState(pCurrentPos.above()).is((Block)this)) {
                RopeLadderBlock.dropResources((BlockState)pState, (Level)level, (BlockPos)pCurrentPos);
                pLevel.setBlock(pCurrentPos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)ContentHandler.rope.get(), ConfigHandler.getRopePerLadder()));
        drops.add(new ItemStack((ItemLike)this.getSlab(), ConfigHandler.getWoodPerLadder()));
        return drops;
    }
}

