/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.datagen.server;

import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModAdvancementsProvider
extends AdvancementProvider {
    public ModAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new ModAdvancementGenerator()));
    }

    public static class ModAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            AdvancementHolder root = Advancement.Builder.advancement().display(ModAdvancementGenerator.rootDisplay((ItemLike)ContentHandler.rope.get(), ModAdvancementGenerator.advancementPrefix("root.title"), ModAdvancementGenerator.advancementPrefix("root.desc"), ResourceLocation.withDefaultNamespace((String)"textures/block/oak_log_top.png"))).addCriterion("air", EnterBlockTrigger.TriggerInstance.entersBlock((Block)Blocks.AIR)).save(consumer, ModAdvancementGenerator.rootID("root"));
            AdvancementHolder craftBridge = Advancement.Builder.advancement().parent(root).display(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.bridge_builder.get(), "craft_bridge_builder")).addCriterion("craft_bridge_builder", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ContentHandler.bridge_builder.get()})).save(consumer, ModAdvancementGenerator.rootID("craft_bridge_builder"));
            AdvancementHolder buildBridge = Advancement.Builder.advancement().parent(craftBridge).display(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.oak_bridge.get(), "build_bridge")).addCriterion("build_ladder", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, ModAdvancementGenerator.rootID("build_bridge"));
            AdvancementHolder craftLadder = Advancement.Builder.advancement().parent(root).display(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.ladder_builder.get(), "craft_ladder_builder")).addCriterion("craft_ladder_builder", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ContentHandler.ladder_builder.get()})).save(consumer, ModAdvancementGenerator.rootID("craft_ladder_builder"));
            AdvancementHolder buildLadder = Advancement.Builder.advancement().parent(craftLadder).display(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.oak_rope_ladder.get(), "build_ladder")).addCriterion("build_ladder", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, ModAdvancementGenerator.rootID("build_ladder"));
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), Optional.of(background), AdvancementType.TASK, true, false, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)ModAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.translatable((String)ModAdvancementGenerator.advancementPrefix(name + ".desc")), Optional.empty(), AdvancementType.TASK, true, false, false);
        }

        private static String advancementPrefix(String name) {
            return "advancement.ropebridge." + name;
        }

        private static String rootID(String name) {
            return Constants.modLoc("main/" + name).toString();
        }
    }
}

