/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.block.RopeLadderBlock;
import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.BlockItemUseContextExt;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class LadderBuildingHandler {
    public static void newLadder(BlockPos selected, Player player, Level level, Direction hitSide, ItemStack builder) {
        if (!hitSide.getAxis().isHorizontal()) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.bad_side", hitSide == Direction.UP ? I18n.get((String)"chat.ropebridge.params.top", (Object[])new Object[0]) : I18n.get((String)"chat.ropebridge.params.bottom", (Object[])new Object[0]));
            return;
        }
        BlockState ladderState = (BlockState)((RopeLadderBlock)((Object)ContentHandler.oak_rope_ladder.get())).defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)hitSide);
        if (!ladderState.canSurvive((LevelReader)level, selected.relative(hitSide))) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.not_solid", new Object[0]);
            return;
        }
        int count = LadderBuildingHandler.countBlocks(selected.relative(hitSide), level);
        if (count <= 0) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.obstruction", new Object[0]);
            return;
        }
        int woodNeeded = count * ConfigHandler.getWoodPerLadder();
        int ropeNeeded = count * ConfigHandler.getRopePerLadder();
        Block slabToUse = LadderBuildingHandler.getSlabToUse(player);
        if (!player.getAbilities().instabuild && !LadderBuildingHandler.hasMaterials(player, woodNeeded, ropeNeeded, slabToUse)) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.underfunded_ladder", woodNeeded, ropeNeeded);
            return;
        }
        if (!player.getAbilities().instabuild) {
            builder.hurtAndBreak(ConfigHandler.getLadderDamage(), (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        }
        LadderBuildingHandler.consume(player, woodNeeded, ropeNeeded, slabToUse);
        LadderBuildingHandler.build(level, selected.relative(hitSide), count, hitSide, slabToUse);
        ModUtils.unlockAdvancement(player, Constants.BUILD_LADDER_ADVANCEMENT);
    }

    public static int countBlocks(BlockPos start, Level level) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)start);
        int count = 0;
        BlockState state = level.getBlockState(start);
        while (LadderBuildingHandler.isReplaceable(level, start, state)) {
            ++count;
            start = start.below();
            state = level.getBlockState(start);
        }
        return count;
    }

    public static boolean isReplaceable(Level level, BlockPos pos, BlockState state) {
        BlockItemUseContextExt blockItemUseContext = new BlockItemUseContextExt(level, null, InteractionHand.MAIN_HAND, ItemStack.EMPTY, new BlockHitResult(new Vec3((double)pos.getX() + 0.5 + (double)Direction.DOWN.getStepX() * 0.5, (double)pos.getY() + 0.5 + (double)Direction.DOWN.getStepY() * 0.5, (double)pos.getZ() + 0.5 + (double)Direction.DOWN.getStepZ() * 0.5), Direction.DOWN, pos, false));
        return pos.getY() > level.getMinBuildHeight() && state.canBeReplaced((BlockPlaceContext)blockItemUseContext);
    }

    private static void build(Level level, BlockPos start, int count, Direction facing, Block type) {
        LadderBuildingHandler.build(level, start, count, 0, facing, type);
    }

    private static void build(final Level level, final BlockPos start, final int count, final int iterations, final Direction facing, final Block slabToUse) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            BlockState state = (BlockState)((Block)((DeferredBlock)ModUtils.map.get(slabToUse).getRight()).get()).defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)facing);
            level.setBlockAndUpdate(start.below(iterations), state);
        });
        if (iterations + 1 < count) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    LadderBuildingHandler.build(level, start, count, iterations + 1, facing, slabToUse);
                }
            }, 100L);
        }
    }

    private static void consume(Player player, int woodNeeded, int ropeNeeded, Block woodType) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getRopePerLadder() == 0 && ConfigHandler.getWoodPerLadder() == 0;
        if (player.getAbilities().instabuild || noCost) {
            return;
        }
        player.getInventory().clearOrCountMatchingItems(stack -> stack.is((Item)ContentHandler.rope.get()), ropeNeeded, (Container)player.inventoryMenu.getCraftSlots());
        player.getInventory().clearOrCountMatchingItems(stack -> stack.getItem() == woodType.asItem(), woodNeeded, (Container)player.inventoryMenu.getCraftSlots());
    }

    private static Block getSlabToUse(Player player) {
        return player.getInventory().items.stream().filter(stack -> stack.is(ItemTags.WOODEN_SLABS)).findFirst().map(stack -> Block.byItem((Item)stack.getItem())).orElse(Blocks.OAK_SLAB);
    }

    private static boolean hasMaterials(Player player, int woodNeeded, int ropeNeeded, Block toFind) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getRopePerLadder() == 0 && ConfigHandler.getWoodPerLadder() == 0;
        if (noCost || player.getAbilities().instabuild) {
            return true;
        }
        for (ItemStack i : player.getInventory().items) {
            if (i.isEmpty()) continue;
            Item item = i.getItem();
            if (i.is((Item)ContentHandler.rope.get())) {
                ropeNeeded -= i.getCount();
                continue;
            }
            if (item != toFind.asItem()) continue;
            woodNeeded -= i.getCount();
        }
        return woodNeeded <= 0 && ropeNeeded <= 0;
    }
}

