/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.lib;

import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.apache.commons.lang3.tuple.Pair;

public class ModUtils {
    public static final Map<Block, Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>> map = new HashMap<Block, Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>>();

    private ModUtils() {
    }

    public static void tellPlayer(Player sender, String message, Object ... params) {
        sender.sendSystemMessage((Component)Component.translatable((String)message, (Object[])params));
    }

    public static void initMap() {
        map.put(Blocks.OAK_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.oak_bridge, ContentHandler.oak_rope_ladder));
        map.put(Blocks.BIRCH_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.birch_bridge, ContentHandler.birch_rope_ladder));
        map.put(Blocks.JUNGLE_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.jungle_bridge, ContentHandler.jungle_rope_ladder));
        map.put(Blocks.SPRUCE_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.spruce_bridge, ContentHandler.spruce_rope_ladder));
        map.put(Blocks.ACACIA_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.acacia_bridge, ContentHandler.acacia_rope_ladder));
        map.put(Blocks.CHERRY_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.cherry_bridge, ContentHandler.cherry_rope_ladder));
        map.put(Blocks.DARK_OAK_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.dark_oak_bridge, ContentHandler.dark_oak_rope_ladder));
        map.put(Blocks.MANGROVE_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.mangrove_bridge, ContentHandler.mangrove_rope_ladder));
        map.put(Blocks.BAMBOO_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.bamboo_bridge, ContentHandler.bamboo_rope_ladder));
        map.put(Blocks.CRIMSON_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.crimson_bridge, ContentHandler.crimson_rope_ladder));
        map.put(Blocks.WARPED_SLAB, (Pair<DeferredBlock<? extends Block>, DeferredBlock<? extends Block>>)Pair.of(ContentHandler.warped_bridge, ContentHandler.warped_rope_ladder));
    }

    public static void unlockAdvancement(Player player, ResourceLocation advancementId) {
        AdvancementProgress advancementprogress;
        AdvancementHolder advancementHolder;
        ServerPlayer serverPlayer;
        MinecraftServer server;
        if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).getServer()) != null && (advancementHolder = server.getAdvancements().get(advancementId)) != null && !(advancementprogress = serverPlayer.getAdvancements().getOrStartProgress(advancementHolder)).isDone()) {
            for (String s : advancementprogress.getRemainingCriteria()) {
                serverPlayer.getAdvancements().award(advancementHolder, s);
            }
        }
    }
}

