/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.block;

import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeBridgeBlock
extends Block {
    private final Supplier<Block> slabSupplier;
    public static final IntegerProperty PROPERTY_HEIGHT = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    public static final IntegerProperty PROPERTY_BACK = IntegerProperty.m_61631_((String)"back", (int)0, (int)3);
    public static final BooleanProperty ROTATED = BooleanProperty.m_61465_((String)"rotated");
    public static final VoxelShape ZERO_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape ONE_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape TWO_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape THREE_AABB = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public RopeBridgeBlock(BlockBehaviour.Properties properties, Supplier<Block> slabSupplier) {
        super(properties);
        this.slabSupplier = slabSupplier;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_HEIGHT, PROPERTY_BACK, ROTATED});
    }

    public Block getSlab() {
        return this.slabSupplier.get();
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        int level = (Integer)state.m_61143_((Property)PROPERTY_HEIGHT);
        return switch (level) {
            case 1 -> ONE_AABB;
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            default -> ZERO_AABB;
        };
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_ && player.m_21205_().m_150930_((Item)ContentHandler.bridge_builder.get()) && player.m_6047_()) {
            ModUtils.tellPlayer(player, "chat.ropebridge.warning.breaking", new Object[0]);
            boolean rotate = (Boolean)level.m_8055_(pos).m_61143_((Property)ROTATED);
            if (rotate) {
                this.breakNorth(pos, (ServerLevel)level);
                this.breakSouth(pos, (ServerLevel)level);
            } else {
                this.breakEast(pos, (ServerLevel)level);
                this.breakWest(pos, (ServerLevel)level);
            }
        }
    }

    public void breakSouth(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos south = posToBreak.m_122019_();
        final BlockPos up = south.m_7494_();
        final BlockPos down = south.m_7495_();
        BlockState stateDown = world.m_8055_(down);
        BlockState stateUp = world.m_8055_(up);
        BlockState state = world.m_8055_(south);
        if (state.m_60734_() == this) {
            world.m_46961_(south, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(south, world);
                }
            }, 100L);
        }
        if (stateUp.m_60734_() == this) {
            world.m_46961_(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(up, world);
                }
            }, 100L);
        }
        if (stateDown.m_60734_() == this) {
            world.m_46961_(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(down, world);
                }
            }, 100L);
        }
    }

    public void breakNorth(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos north = posToBreak.m_122012_();
        final BlockPos up = north.m_7494_();
        final BlockPos down = north.m_7495_();
        BlockState stateDown = world.m_8055_(down);
        BlockState stateUp = world.m_8055_(up);
        BlockState state = world.m_8055_(north);
        if (state.m_60734_() == this) {
            world.m_46961_(north, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(north, world);
                }
            }, 100L);
        }
        if (stateUp.m_60734_() == this) {
            world.m_46961_(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(up, world);
                }
            }, 100L);
        }
        if (stateDown.m_60734_() == this) {
            world.m_46961_(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(down, world);
                }
            }, 100L);
        }
    }

    public void breakEast(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos east = posToBreak.m_122029_();
        final BlockPos up = east.m_7494_();
        final BlockPos down = east.m_7495_();
        BlockState stateDown = world.m_8055_(down);
        BlockState stateUp = world.m_8055_(up);
        BlockState state = world.m_8055_(east);
        if (state.m_60734_() == this) {
            world.m_46961_(east, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(east, world);
                }
            }, 100L);
        }
        if (stateUp.m_60734_() == this) {
            world.m_46961_(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(up, world);
                }
            }, 100L);
        }
        if (stateDown.m_60734_() == this) {
            world.m_46961_(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(down, world);
                }
            }, 100L);
        }
    }

    public void breakWest(BlockPos posToBreak, final ServerLevel world) {
        final BlockPos west = posToBreak.m_122024_();
        final BlockPos up = west.m_7494_();
        final BlockPos down = west.m_7495_();
        BlockState stateDown = world.m_8055_(down);
        BlockState stateUp = world.m_8055_(up);
        BlockState state = world.m_8055_(west);
        if (state.m_60734_() == this) {
            world.m_46961_(west, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(west, world);
                }
            }, 100L);
        }
        if (stateUp.m_60734_() == this) {
            world.m_46961_(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(up, world);
                }
            }, 100L);
        }
        if (stateDown.m_60734_() == this) {
            world.m_46961_(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(down, world);
                }
            }, 100L);
        }
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)ContentHandler.rope.get(), ConfigHandler.getRopePerBridge()));
        drops.add(new ItemStack((ItemLike)this.getSlab(), ConfigHandler.getSlabsPerBridge()));
        return drops;
    }
}

