/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.datagen.server;

import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.jetbrains.annotations.Nullable;

public class ModAdvancementsProvider
extends ForgeAdvancementProvider {
    public ModAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new ModAdvancementGenerator()));
    }

    public static class ModAdvancementGenerator
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider provider, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
            Advancement root = Advancement.Builder.m_138353_().m_138358_(ModAdvancementGenerator.rootDisplay((ItemLike)ContentHandler.rope.get(), ModAdvancementGenerator.advancementPrefix("root.title"), ModAdvancementGenerator.advancementPrefix("root.desc"), new ResourceLocation("textures/block/oak_log_top.png"))).m_138386_("air", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)Blocks.f_50016_)).m_138389_(consumer, ModAdvancementGenerator.rootID("root"));
            Advancement craftBridge = Advancement.Builder.m_138353_().m_138398_(root).m_138358_(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.bridge_builder.get(), "craft_bridge_builder")).m_138386_("craft_bridge_builder", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ContentHandler.bridge_builder.get()})).m_138389_(consumer, ModAdvancementGenerator.rootID("craft_bridge_builder"));
            Advancement buildBridge = Advancement.Builder.m_138353_().m_138398_(craftBridge).m_138358_(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.oak_bridge.get(), "build_bridge")).m_138386_("build_bridge", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, ModAdvancementGenerator.rootID("build_bridge"));
            Advancement craftLadder = Advancement.Builder.m_138353_().m_138398_(root).m_138358_(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.ladder_builder.get(), "craft_ladder_builder")).m_138386_("craft_ladder_builder", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ContentHandler.ladder_builder.get()})).m_138389_(consumer, ModAdvancementGenerator.rootID("craft_ladder_builder"));
            Advancement buildLadder = Advancement.Builder.m_138353_().m_138398_(craftLadder).m_138358_(ModAdvancementGenerator.simpleDisplay((ItemLike)ContentHandler.oak_rope_ladder.get(), "build_ladder")).m_138386_("build_ladder", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, ModAdvancementGenerator.rootID("build_ladder"));
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, @Nullable ResourceLocation background) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)titleKey), (Component)Component.m_237115_((String)descKey), background, FrameType.TASK, true, false, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name) {
            return new DisplayInfo(new ItemStack((ItemLike)icon.m_5456_()), (Component)Component.m_237115_((String)ModAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.m_237115_((String)ModAdvancementGenerator.advancementPrefix(name + ".desc")), null, FrameType.TASK, true, false, false);
        }

        private static String advancementPrefix(String name) {
            return "advancement.ropebridge." + name;
        }

        private static String rootID(String name) {
            return Constants.modLoc("main/" + name).toString();
        }
    }
}

