/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.handler.LadderBuildingHandler;
import com.mrtrollnugnug.ropebridge.handler.SlabPosHandler;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;

public class BridgeBuildingHandler {
    private BridgeBuildingHandler() {
    }

    public static void newBridge(Player player, ItemStack stack, BlockPos pos1, BlockPos pos2) {
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        LinkedList<SlabPosHandler> bridge = new LinkedList<SlabPosHandler>();
        boolean allClear = true;
        boolean rotate = BridgeBuildingHandler.getRotate(pos1, pos2);
        if (!rotate) {
            x1 = pos1.m_123341_();
            y1 = pos1.m_123342_();
            z1 = pos1.m_123343_();
            x2 = pos2.m_123341_();
            y2 = pos2.m_123342_();
            z2 = pos2.m_123343_();
        } else {
            x1 = pos1.m_123343_();
            y1 = pos1.m_123342_();
            z1 = pos1.m_123341_();
            x2 = pos2.m_123343_();
            y2 = pos2.m_123342_();
            z2 = pos2.m_123341_();
        }
        if (Math.abs(z2 - z1) > 3) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.notcardinal", new Object[0]);
            return;
        }
        double m = (double)(y2 - y1) / (double)(x2 - x1);
        if (!ConfigHandler.isIgnoreSlopeWarnings() && Math.abs(m) > 0.2) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.greatslope", new Object[0]);
            return;
        }
        double b = (double)y1 - m * (double)x1;
        double distance = Math.abs(x2 - x1);
        int distInt = Math.abs(x2 - x1);
        if (distInt < 2) {
            return;
        }
        if (!player.m_150110_().f_35937_ && !BridgeBuildingHandler.hasMaterials(player, distInt - 1)) {
            return;
        }
        for (int x = Math.min(x1, x2) + 1; x <= Math.max(x1, x2) - 1; ++x) {
            for (int y = Math.max(y1, y2); y >= Math.min(y1, y2) - distInt / 8 - 1; --y) {
                double funcVal = m * (double)x + b - distance / 1000.0 * Math.sin((double)(x - Math.min(x1, x2)) * (Math.PI / distance)) * (double)ConfigHandler.getBridgeDroopFactor() + ConfigHandler.getBridgeYOffset();
                if (!((double)y + 0.5 > funcVal) || !((double)y - 0.5 <= funcVal)) continue;
                int level = funcVal >= (double)y ? (funcVal >= (double)y + 0.25 ? 3 : 2) : (funcVal >= (double)y - 0.25 ? 1 : 0);
                allClear = BridgeBuildingHandler.addSlab(player.m_9236_(), bridge, x, y + 1, z1, level, rotate) && allClear;
            }
        }
        if (allClear) {
            Block slab = BridgeBuildingHandler.getSlabs(player);
            if (slab != null && !player.m_150110_().f_35937_) {
                BridgeBuildingHandler.takeMaterials(player, distInt - 1);
                stack.m_41622_(ConfigHandler.getBridgeDamage(), (LivingEntity)player, playerEntity -> playerEntity.m_21190_(player.m_7655_()));
            }
            BridgeBuildingHandler.buildBridge(player.m_9236_(), bridge, slab, 0, rotate);
            ModUtils.unlockAdvancement(player, Constants.BUILD_BRIDGE_ADVANCEMENT);
        } else {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.obstruction", new Object[0]);
        }
    }

    private static boolean getRotate(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.m_123341_() - p2.m_123341_()) <= Math.abs(p1.m_123343_() - p2.m_123343_());
    }

    private static boolean hasMaterials(Player player, int dist) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getSlabsPerBridge() == 0 && ConfigHandler.getRopePerBridge() == 0;
        if (player.m_150110_().f_35937_ || noCost) {
            return true;
        }
        int ropeNeeded = dist * ConfigHandler.getRopePerBridge();
        int slabsNeeded = dist * ConfigHandler.getSlabsPerBridge();
        int slabsHad = 0;
        int ropeHad = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ContentHandler.rope.get())) {
                ropeHad += stack.m_41613_();
            }
            if (!stack.m_204117_(ItemTags.f_13175_)) continue;
            slabsHad += stack.m_41613_();
        }
        if (slabsHad >= slabsNeeded && ropeHad >= ropeNeeded) {
            return true;
        }
        ModUtils.tellPlayer(player, "chat.ropebridge.info.underfunded_bridge", dist, ropeNeeded);
        return false;
    }

    private static void takeMaterials(Player player, int dist) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getSlabsPerBridge() == 0 && ConfigHandler.getRopePerBridge() == 0;
        if (player.m_150110_().f_35937_ || noCost) {
            return;
        }
        int slabsNeeded = dist * ConfigHandler.getSlabsPerBridge();
        int ropeNeeded = dist * ConfigHandler.getRopePerBridge();
        for (int i = 0; i < 36; ++i) {
            int toConsume;
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_()) continue;
            if (ropeNeeded > 0 && stack.m_150930_((Item)ContentHandler.rope.get())) {
                toConsume = Math.min(stack.m_41613_(), ropeNeeded);
                ropeNeeded -= toConsume;
                stack.m_41774_(toConsume);
                continue;
            }
            if (slabsNeeded <= 0 || !stack.m_204117_(ItemTags.f_13175_)) continue;
            toConsume = Math.min(stack.m_41613_(), slabsNeeded);
            slabsNeeded -= toConsume;
            stack.m_41774_(toConsume);
        }
    }

    private static boolean addSlab(Level blockGetter, LinkedList<SlabPosHandler> list, int x, int y, int z, int level, boolean rotate) {
        BlockPos pos = rotate ? new BlockPos(z, y, x) : new BlockPos(x, y, z);
        boolean isClear = ConfigHandler.isBreakThroughBlocks() || blockGetter.m_46859_(pos) || LadderBuildingHandler.isReplaceable(blockGetter, pos, blockGetter.m_8055_(pos));
        list.add(new SlabPosHandler(pos, level, rotate));
        if (!isClear) {
            BridgeBuildingHandler.spawnSmoke(blockGetter, pos, 15);
        }
        return isClear;
    }

    private static void spawnSmoke(Level level, BlockPos pos, int times) {
        if (times > 0) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            final Level finLevel = level;
            final BlockPos finPos = pos;
            final int finTimes = times - 1;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.spawnSmoke(finLevel, finPos, finTimes);
                }
            }, 1000L);
        }
    }

    private static void buildBridge(final Level level, final List<SlabPosHandler> bridge, final Block slabBlock, final int index, final boolean rotated) {
        if (index < bridge.size()) {
            SlabPosHandler slab = bridge.get(index);
            int backLevel = index > 0 ? bridge.get(index - 1).getLevel() : 0;
            BlockState state = (BlockState)((BlockState)((BlockState)((Block)((RegistryObject)ModUtils.map.get(slabBlock).getLeft()).get()).m_49966_().m_61124_((Property)RopeBridgeBlock.PROPERTY_HEIGHT, (Comparable)Integer.valueOf(slab.getLevel()))).m_61124_((Property)RopeBridgeBlock.PROPERTY_BACK, (Comparable)Integer.valueOf(backLevel))).m_61124_((Property)RopeBridgeBlock.ROTATED, (Comparable)Boolean.valueOf(rotated));
            level.m_46597_(slab.getBlockPos(), state);
            BridgeBuildingHandler.spawnSmoke(level, new BlockPos(slab.getBlockPos().m_123341_(), slab.getBlockPos().m_123342_(), slab.getBlockPos().m_123343_()), 1);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.buildBridge(level, bridge, slabBlock, index + 1, rotated);
                }
            }, 100L);
        }
    }

    private static Block getSlabs(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_204117_(ItemTags.f_13175_)) continue;
            return Block.m_49814_((Item)stack.m_41720_());
        }
        return Blocks.f_50398_;
    }
}

