/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.block.RopeLadderBlock;
import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.lib.BlockItemUseContextExt;
import com.mrtrollnugnug.ropebridge.lib.Constants;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

public class LadderBuildingHandler {
    public static void newLadder(BlockPos selected, Player player, Level level, Direction hitSide, ItemStack builder) {
        if (!hitSide.m_122434_().m_122479_()) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.bad_side", hitSide == Direction.UP ? I18n.m_118938_((String)"chat.ropebridge.params.top", (Object[])new Object[0]) : I18n.m_118938_((String)"chat.ropebridge.params.bottom", (Object[])new Object[0]));
            return;
        }
        BlockState ladderState = (BlockState)((RopeLadderBlock)((Object)ContentHandler.oak_rope_ladder.get())).m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)hitSide);
        if (!ladderState.m_60710_((LevelReader)level, selected.m_121945_(hitSide))) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.not_solid", new Object[0]);
            return;
        }
        int count = LadderBuildingHandler.countBlocks(selected.m_121945_(hitSide), level);
        if (count <= 0) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.obstruction", new Object[0]);
            return;
        }
        int woodNeeded = count * ConfigHandler.getWoodPerLadder();
        int ropeNeeded = count * ConfigHandler.getRopePerLadder();
        Block slabToUse = LadderBuildingHandler.getSlabToUse(player);
        if (!player.m_150110_().f_35937_ && !LadderBuildingHandler.hasMaterials(player, woodNeeded, ropeNeeded, slabToUse)) {
            ModUtils.tellPlayer(player, "chat.ropebridge.info.underfunded_ladder", woodNeeded, ropeNeeded);
            return;
        }
        if (!player.m_150110_().f_35937_) {
            builder.m_41622_(ConfigHandler.getLadderDamage(), (LivingEntity)player, playerEntity -> playerEntity.m_21190_(player.m_7655_()));
        }
        LadderBuildingHandler.consume(player, woodNeeded, ropeNeeded, slabToUse);
        LadderBuildingHandler.build(level, selected.m_121945_(hitSide), count, hitSide, slabToUse);
        ModUtils.unlockAdvancement(player, Constants.BUILD_LADDER_ADVANCEMENT);
    }

    public static int countBlocks(BlockPos start, Level level) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)start);
        int count = 0;
        BlockState state = level.m_8055_(start);
        while (LadderBuildingHandler.isReplaceable(level, start, state)) {
            ++count;
            start = start.m_7495_();
            state = level.m_8055_(start);
        }
        return count;
    }

    public static boolean isReplaceable(Level level, BlockPos pos, BlockState state) {
        BlockItemUseContextExt blockItemUseContext = new BlockItemUseContextExt(level, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5 + (double)Direction.DOWN.m_122429_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)Direction.DOWN.m_122430_() * 0.5, (double)pos.m_123343_() + 0.5 + (double)Direction.DOWN.m_122431_() * 0.5), Direction.DOWN, pos, false));
        return pos.m_123342_() > level.m_141937_() && state.m_60629_((BlockPlaceContext)blockItemUseContext);
    }

    private static void build(Level level, BlockPos start, int count, Direction facing, Block type) {
        LadderBuildingHandler.build(level, start, count, 0, facing, type);
    }

    private static void build(final Level level, final BlockPos start, final int count, final int iterations, final Direction facing, final Block slabToUse) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            BlockState state = (BlockState)((Block)((RegistryObject)ModUtils.map.get(slabToUse).getRight()).get()).m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)facing);
            level.m_46597_(start.m_6625_(iterations), state);
        });
        if (iterations + 1 < count) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    LadderBuildingHandler.build(level, start, count, iterations + 1, facing, slabToUse);
                }
            }, 100L);
        }
    }

    private static void consume(Player player, int woodNeeded, int ropeNeeded, Block woodType) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getRopePerLadder() == 0 && ConfigHandler.getWoodPerLadder() == 0;
        if (player.m_150110_().f_35937_ || noCost) {
            return;
        }
        player.m_150109_().m_36022_(stack -> stack.m_150930_((Item)ContentHandler.rope.get()), ropeNeeded, (Container)player.f_36095_.m_39730_());
        player.m_150109_().m_36022_(stack -> stack.m_41720_() == woodType.m_5456_(), woodNeeded, (Container)player.f_36095_.m_39730_());
    }

    private static Block getSlabToUse(Player player) {
        return player.m_150109_().f_35974_.stream().filter(stack -> stack.m_204117_(ItemTags.f_13175_)).findFirst().map(stack -> Block.m_49814_((Item)stack.m_41720_())).orElse(Blocks.f_50398_);
    }

    private static boolean hasMaterials(Player player, int woodNeeded, int ropeNeeded, Block toFind) {
        boolean noCost;
        boolean bl = noCost = ConfigHandler.getRopePerLadder() == 0 && ConfigHandler.getWoodPerLadder() == 0;
        if (noCost || player.m_150110_().f_35937_) {
            return true;
        }
        for (ItemStack i : player.m_150109_().f_35974_) {
            if (i.m_41619_()) continue;
            Item item = i.m_41720_();
            if (i.m_150930_((Item)ContentHandler.rope.get())) {
                ropeNeeded -= i.m_41613_();
                continue;
            }
            if (item != toFind.m_5456_()) continue;
            woodNeeded -= i.m_41613_();
        }
        return woodNeeded <= 0 && ropeNeeded <= 0;
    }
}

