/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.item;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.handler.BridgeBuildingHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.item.ItemBuilder;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ItemBridgeBuilder
extends ItemBuilder {
    public ItemBridgeBuilder(Item.Properties properties) {
        super(properties);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        super.m_5929_(level, livingEntity, stack, remainingUseDuration);
        if (livingEntity.m_9236_().f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemBridgeBuilder.rotatePlayerTowards(player, ItemBridgeBuilder.getNearestYaw(player));
        }
    }

    private static void rotatePlayerTowards(Player player, float target) {
        float yaw = player.m_146908_() % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        ItemBridgeBuilder.rotatePlayerTo(player, yaw + (target - yaw) / 4.0f);
    }

    private static void rotatePlayerTo(Player player, float yaw) {
        float original = player.m_146908_();
        player.m_146922_(yaw);
        player.f_19859_ += player.m_146908_() - original;
    }

    private static float getNearestYaw(Player player) {
        float yaw = player.m_146908_() % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return 90.0f;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return 180.0f;
        }
        if (yaw > 225.0f && yaw <= 315.0f) {
            return 270.0f;
        }
        return 360.0f;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!level.f_46443_ && this.m_8105_(stack) - timeCharged > 10) {
                if (!player.m_20096_()) {
                    ModUtils.tellPlayer(player, "chat.ropebridge.info.notonground", new Object[0]);
                } else {
                    HitResult hit = ItemBridgeBuilder.trace(player);
                    if (hit instanceof BlockHitResult) {
                        BlockHitResult blockHitResult = (BlockHitResult)hit;
                        BlockPos floored = BlockPos.m_274561_((double)player.m_20185_(), (double)(player.m_20186_() - 1.0), (double)player.m_20189_()).m_7495_();
                        BlockPos target = blockHitResult.m_82425_();
                        BridgeBuildingHandler.newBridge(player, player.m_21205_(), floored, target);
                        level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ContentHandler.swoosh.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
                    }
                }
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (ItemBridgeBuilder.isBridgeBlock(state.m_60734_())) {
            return 1.0f;
        }
        return super.m_8102_(stack, state);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237113_((String)"- Hold right-click to build"));
        tooltip.add((Component)Component.m_237113_((String)"- Sneak to break whole bridge"));
    }

    private static boolean isBridgeBlock(Block block) {
        return block instanceof RopeBridgeBlock;
    }
}

