/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib;

import baguchi.bagus_lib.BagusConfigs;
import baguchi.bagus_lib.command.DialogCommand;
import baguchi.bagus_lib.item.ModItems;
import baguchi.bagus_lib.message.CameraMessage;
import baguchi.bagus_lib.message.DialogMessage;
import baguchi.bagus_lib.message.EntityCameraMessage;
import baguchi.bagus_lib.message.PlayerDataSyncMessage;
import baguchi.bagus_lib.message.RemoveAllDialogMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsStopAllMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsStopMessage;
import baguchi.bagus_lib.message.SyncEntityPacketToServer;
import baguchi.bagus_lib.register.ModDialogs;
import baguchi.bagus_lib.register.ModEntities;
import baguchi.bagus_lib.register.ModLootModifiers;
import baguchi.bagus_lib.register.ModSensors;
import baguchi.bagus_lib.register.ModStructureProcessorTypes;
import baguchi.bagus_lib.util.reward.TierHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bagus_lib")
public class BagusLib {
    public static final String MODID = "bagus_lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"bagus_lib");

    public BagusLib(IEventBus modEventBus, ModContainer modContainer) {
        ModItems.ITEM_REGISTRY.register(modEventBus);
        ModEntities.ENTITIES_REGISTRY.register(modEventBus);
        ModStructureProcessorTypes.PROCESSOR_TYPE.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        ModSensors.SENSOR_TYPES.register(modEventBus);
        ModDialogs.DIALOG.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupPackets);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BagusConfigs.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BagusConfigs.CLIENT_SPEC);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TierHelper.addSuporterContents();
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playBidirectional(CameraMessage.TYPE, CameraMessage.STREAM_CODEC, (handler, payload) -> handler.handle((CameraMessage)handler, payload));
        registrar.playBidirectional(EntityCameraMessage.TYPE, EntityCameraMessage.STREAM_CODEC, (handler, payload) -> handler.handle((EntityCameraMessage)handler, payload));
        registrar.playBidirectional(PlayerDataSyncMessage.TYPE, PlayerDataSyncMessage.STREAM_CODEC, (handler, payload) -> handler.handle((PlayerDataSyncMessage)handler, payload));
        registrar.playBidirectional(SyncEntityPacketToServer.TYPE, SyncEntityPacketToServer.STREAM_CODEC, (handler, payload) -> handler.handle((SyncEntityPacketToServer)handler, payload));
        registrar.playBidirectional(DialogMessage.TYPE, DialogMessage.STREAM_CODEC, (handler, payload) -> handler.handle((DialogMessage)handler, payload));
        registrar.playBidirectional(RemoveAllDialogMessage.TYPE, RemoveAllDialogMessage.STREAM_CODEC, (handler, payload) -> handler.handle((RemoveAllDialogMessage)handler, payload));
        registrar.playBidirectional(SyncBagusAnimationsMessage.TYPE, SyncBagusAnimationsMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SyncBagusAnimationsMessage)handler, payload));
        registrar.playBidirectional(SyncBagusAnimationsStopMessage.TYPE, SyncBagusAnimationsStopMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SyncBagusAnimationsStopMessage)handler, payload));
        registrar.playBidirectional(SyncBagusAnimationsStopAllMessage.TYPE, SyncBagusAnimationsStopAllMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SyncBagusAnimationsStopAllMessage)handler, payload));
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        DialogCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext());
    }
}

