/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.dialog;

import baguchi.bagus_lib.client.dialog.DialogType;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class ImageDialogType
extends DialogType {
    @Nullable
    protected ResourceLocation resourceLocation;
    protected int sizeX = 32;
    protected int sizeY = 32;

    @Override
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount) {
        if (this.resourceLocation != null) {
            poseStack.pushPose();
            poseStack.translate(0.0f, (float)this.renderDialogY, 0.0f);
            poseStack.scale(this.scaleX, this.scaleY, 1.0f);
            guiGraphics.blitSprite(RenderType::guiTextured, this.resourceLocation, this.posX, this.posY, this.sizeX, this.sizeY);
            poseStack.popPose();
        }
    }

    @Override
    protected CompoundTag writeTag() {
        CompoundTag tag = super.writeTag();
        if (this.resourceLocation != null) {
            tag.putString("ImagePath", this.resourceLocation.toString());
        }
        tag.putInt("sizeX", this.sizeX);
        tag.putInt("sizeY", this.sizeY);
        return tag;
    }

    @Override
    protected void readTag(CompoundTag tag) {
        super.readTag(tag);
        if (tag.contains("ImagePath")) {
            this.resourceLocation = ResourceLocation.tryParse((String)tag.getString("ImagePath"));
        }
        if (tag.contains("sizeX")) {
            this.sizeX = tag.getInt("sizeX");
        }
        if (tag.contains("sizeY")) {
            this.sizeY = tag.getInt("sizeY");
        }
    }

    @Override
    public ImageDialogType getClone(CompoundTag compoundTag) {
        ImageDialogType dialogType = new ImageDialogType();
        dialogType.readTag(compoundTag);
        return dialogType;
    }
}

