/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.dialog;

import baguchi.bagus_lib.client.dialog.DialogType;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemDialogType
extends DialogType {
    protected ItemStack itemStack = ItemStack.EMPTY;

    @Override
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount) {
        if (this.itemStack != null) {
            poseStack.pushPose();
            poseStack.translate(0.0f, (float)this.renderDialogY, 0.0f);
            poseStack.scale(this.scaleX, this.scaleY, 1.0f);
            guiGraphics.renderItem(this.itemStack, this.posX, this.posY);
            poseStack.popPose();
        }
    }

    @Override
    protected CompoundTag writeTag() {
        CompoundTag tag = super.writeTag();
        if (this.itemStack != null) {
            tag.putString("Item", BuiltInRegistries.ITEM.getKey((Object)this.itemStack.getItem()).toString());
        }
        return tag;
    }

    @Override
    protected void readTag(CompoundTag tag) {
        super.readTag(tag);
        if (tag.contains("Item")) {
            BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)tag.getString("Item"))).ifPresent(itemReference -> {
                this.itemStack = ((Item)itemReference.value()).getDefaultInstance();
            });
        }
    }

    @Override
    public ItemDialogType getClone(CompoundTag compoundTag) {
        ItemDialogType dialogType = new ItemDialogType();
        dialogType.readTag(compoundTag);
        return dialogType;
    }
}

