/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft;

import baguchi.tofucraft.TofuConfig;
import baguchi.tofucraft.api.TofunianTradeManager;
import baguchi.tofucraft.api.entity.TofunianVariant;
import baguchi.tofucraft.api.tfenergy.TofuEnergyMap;
import baguchi.tofucraft.client.ClientRegistrar;
import baguchi.tofucraft.data.resources.registries.TofunianVariants;
import baguchi.tofucraft.event.CraftingEvents;
import baguchi.tofucraft.network.BossInfoPacket;
import baguchi.tofucraft.network.SaltFurnaceBitternPacket;
import baguchi.tofucraft.network.SaltFurnaceWaterPacket;
import baguchi.tofucraft.network.SoyMilkDrinkedPacket;
import baguchi.tofucraft.network.TFStorageSoymilkPacket;
import baguchi.tofucraft.registry.ModInteractionInformations;
import baguchi.tofucraft.registry.TofuAdvancements;
import baguchi.tofucraft.registry.TofuAttachments;
import baguchi.tofucraft.registry.TofuBiomeSources;
import baguchi.tofucraft.registry.TofuBiomes;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import baguchi.tofucraft.registry.TofuBlockSetTypes;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuCarvers;
import baguchi.tofucraft.registry.TofuCreativeModeTabs;
import baguchi.tofucraft.registry.TofuDataComponents;
import baguchi.tofucraft.registry.TofuEffects;
import baguchi.tofucraft.registry.TofuEnchantmentEffects;
import baguchi.tofucraft.registry.TofuEntityDatas;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuFeatures;
import baguchi.tofucraft.registry.TofuFluidTypes;
import baguchi.tofucraft.registry.TofuFluids;
import baguchi.tofucraft.registry.TofuFoliagePlacerType;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuLootModifiers;
import baguchi.tofucraft.registry.TofuMenus;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.registry.TofuPoiTypes;
import baguchi.tofucraft.registry.TofuProfessions;
import baguchi.tofucraft.registry.TofuRecipes;
import baguchi.tofucraft.registry.TofuSounds;
import baguchi.tofucraft.registry.TofuTags;
import com.google.common.collect.Maps;
import com.google.common.reflect.Reflection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tofucraft")
public class TofuCraftReload {
    public static final String MODID = "tofucraft";
    public static final String NETWORK_PROTOCOL = "2";
    public static final Logger LOGGER = LogManager.getLogger((String)"tofucraft");
    public static final FeatureFlag EXPERIMENTAL = FeatureFlags.REGISTRY.getFlag(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"experimental_extra"));

    public TofuCraftReload(ModContainer modContainer, Dist dist, IEventBus modBus) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        if (dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        modBus.addListener(this::setup);
        modBus.addListener(this::setupPackets);
        Reflection.initialize((Class[])new Class[]{TofuTags.Items.class});
        modBus.addListener(DataPackRegistryEvent.NewRegistry.class, event -> event.dataPackRegistry(TofunianVariants.TOFUNIAN_VARIANT_REGISTRY_KEY, TofunianVariant.DIRECT_CODEC, TofunianVariant.DIRECT_CODEC));
        TofuBlocks.BLOCKS.register(modBus);
        TofuItems.ITEMS.register(modBus);
        TofuItems.ITEMS.addAlias(TofuCraftReload.prefix("sculk_bone_helmet"), TofuCraftReload.prefix("tofu_diamond_helmet"));
        TofuItems.ITEMS.addAlias(TofuCraftReload.prefix("sculk_bone_chestplate"), TofuCraftReload.prefix("tofu_diamond_chestplate"));
        TofuItems.ITEMS.addAlias(TofuCraftReload.prefix("sculk_bone_leggings"), TofuCraftReload.prefix("tofu_diamond_leggings"));
        TofuItems.ITEMS.addAlias(TofuCraftReload.prefix("sculk_bone_boots"), TofuCraftReload.prefix("tofu_diamond_boots"));
        TofuItems.ITEMS.addAlias(TofuCraftReload.prefix("fukumame_thower"), TofuCraftReload.prefix("fukumame_thrower"));
        TofuEntityTypes.ENTITIES.register(modBus);
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("fukumame_thower"), TofuCraftReload.prefix("fukumame_thrower"));
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("tofucow"), TofuCraftReload.prefix("tofu_cow"));
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("tofupig"), TofuCraftReload.prefix("tofu_pig"));
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("tofufish"), TofuCraftReload.prefix("tofu_fish"));
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("tofuslime"), TofuCraftReload.prefix("tofu_slime"));
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("tofucreeper"), TofuCraftReload.prefix("tofu_creeper"));
        TofuEntityTypes.ENTITIES.addAlias(TofuCraftReload.prefix("tofuspider"), TofuCraftReload.prefix("tofu_spider"));
        TofuEnchantmentEffects.ENTITY_EFFECTS.register(modBus);
        TofuBlockEntitys.BLOCK_ENTITIES.register(modBus);
        TofuMenus.MENU_TYPES.register(modBus);
        TofuEffects.MOB_EFFECTS.register(modBus);
        TofuFluidTypes.FLUID_TYPES.register(modBus);
        TofuFluids.FLUIDS.register(modBus);
        modBus.addListener(TofuFluids::registerFluids);
        TofuCreativeModeTabs.CREATIVE_MODE_TABS.register(modBus);
        TofuRecipes.RECIPE_TYPES.register(modBus);
        TofuEntityDatas.ENTITY_DATAS.register(modBus);
        TofuDataComponents.DATA_COMPONENT_TYPES.register(modBus);
        TofuRecipes.RECIPE_SERIALIZERS.register(modBus);
        TofuPoiTypes.POI_TYPES.register(modBus);
        TofuProfessions.PROFESSIONS.register(modBus);
        TofuLootModifiers.LOOT_MODIFIERS.register(modBus);
        TofuFoliagePlacerType.FOLIAGE_PLACER_TYPE.register(modBus);
        TofuFeatures.FEATURES.register(modBus);
        TofuSounds.SOUND_EVENTS.register(modBus);
        TofuAttachments.ATTACHMENT_TYPES.register(modBus);
        TofuParticleTypes.PARTICLE_TYPES.register(modBus);
        TofuAdvancements.CRITERIONS_REGISTER.register(modBus);
        TofuCarvers.WORLD_CARVER.register(modBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modBus.addListener(ClientRegistrar::setup);
        }
        NeoForge.EVENT_BUS.addListener(TofunianTradeManager::loadTrades);
        NeoForge.EVENT_BUS.register((Object)new CraftingEvents());
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TofuConfig.COMMON_SPEC);
        modBus.addListener(TofuCraftReload::registerBETypes);
    }

    private static void registerBETypes(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.SIGN, new Block[]{(Block)TofuBlocks.TOFU_STEM_SIGN.get(), (Block)TofuBlocks.TOFU_STEM_WALL_SIGN.get(), (Block)TofuBlocks.LEEK_SIGN.get(), (Block)TofuBlocks.LEEK_WALL_SIGN.get(), (Block)TofuBlocks.LEEK_GREEN_SIGN.get(), (Block)TofuBlocks.LEEK_GREEN_WALL_SIGN.get()});
        event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)TofuBlocks.TOFU_STEM_HANGING_SIGN.get(), (Block)TofuBlocks.TOFU_STEM_WALL_HANGING_SIGN.get(), (Block)TofuBlocks.LEEK_HANGING_SIGN.get(), (Block)TofuBlocks.LEEK_WALL_HANGING_SIGN.get(), (Block)TofuBlocks.LEEK_GREEN_HANGING_SIGN.get(), (Block)TofuBlocks.LEEK_GREEN_WALL_HANGING_SIGN.get()});
        event.modify(BlockEntityType.BRUSHABLE_BLOCK, new Block[]{(Block)TofuBlocks.SUSPICIOUS_TOFU_TERRAIN.get()});
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HashMap map = Maps.newHashMap();
            map.putAll(Map.copyOf(MultiNoiseBiomeSourceParameterList.Preset.BY_NAME));
            map.put(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"tofu_world"), TofuBiomeSources.TOFU_WORLD_PRESET);
            MultiNoiseBiomeSourceParameterList.Preset.BY_NAME = map;
            TofuBlockSetTypes.init();
            TofuAdvancements.init();
            TofuItems.registerDispenserItem();
            TofuBlocks.flamableInit();
            TofuBiomes.init();
            TofuEnergyMap.init();
            ModInteractionInformations.init();
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.FLOWER_POT;
            pot.addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)TofuBlocks.SAPLING_TOFU.get())), TofuBlocks.POTTED_TOFU_SAPLING);
            pot.addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)TofuBlocks.SAPLING_APRICOT.get())), TofuBlocks.POTTED_APRICOT_SAPLING);
            pot.addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)TofuBlocks.ZUNDATOFU_MUSHROOM.get())), TofuBlocks.POTTED_ZUNDA_TOFU_MUSHROOM);
            pot.addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)TofuBlocks.LEEK.get())), TofuBlocks.POTTED_LEEK);
            pot.addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)TofuBlocks.TOFU_FLOWER.get())), TofuBlocks.POTTED_TOFU_FLOWER);
        });
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playBidirectional(SoyMilkDrinkedPacket.TYPE, SoyMilkDrinkedPacket.STREAM_CODEC, (handler, payload) -> handler.handle((SoyMilkDrinkedPacket)handler, payload));
        registrar.playBidirectional(SaltFurnaceWaterPacket.TYPE, SaltFurnaceWaterPacket.STREAM_CODEC, (handler, payload) -> handler.handle((SaltFurnaceWaterPacket)handler, payload));
        registrar.playBidirectional(SaltFurnaceBitternPacket.TYPE, SaltFurnaceBitternPacket.STREAM_CODEC, (handler, payload) -> handler.handle((SaltFurnaceBitternPacket)handler, payload));
        registrar.playBidirectional(TFStorageSoymilkPacket.TYPE, TFStorageSoymilkPacket.STREAM_CODEC, (handler, payload) -> handler.handle((TFStorageSoymilkPacket)handler, payload));
        registrar.playToClient(BossInfoPacket.Display.TYPE, BossInfoPacket.Display.STREAM_CODEC, BossInfoPacket.Display::execute);
        registrar.playToClient(BossInfoPacket.Remove.TYPE, BossInfoPacket.Remove.STREAM_CODEC, BossInfoPacket.Remove::execute);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }
}

