/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.block.CandleTofuCakeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TofuCakeBlock
extends CakeBlock {
    public static final int MAX_BITES = 6;
    public static final IntegerProperty BITES = BlockStateProperties.BITES;
    public final int foodHeal;
    public final float foodSaturation;
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public TofuCakeBlock(BlockBehaviour.Properties p_51184_, int foodHeal, float foodSaturation) {
        super(p_51184_);
        this.foodHeal = foodHeal;
        this.foodSaturation = foodSaturation;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState p_51222_, BlockGetter p_51223_, BlockPos p_51224_, CollisionContext p_51225_) {
        return SHAPE_BY_BITE[(Integer)p_51222_.getValue((Property)BITES)];
    }

    protected InteractionResult useItemOn(ItemStack p_316238_, BlockState p_316837_, Level p_316766_, BlockPos p_316227_, Player p_316853_, InteractionHand p_316422_, BlockHitResult p_316869_) {
        Block var10;
        Item item = p_316238_.getItem();
        if (p_316238_.is(ItemTags.CANDLES) && (Integer)p_316837_.getValue((Property)BITES) == 0 && (var10 = Block.byItem((Item)item)) instanceof CandleBlock) {
            CandleBlock candleblock = (CandleBlock)var10;
            p_316238_.consume(1, (LivingEntity)p_316853_);
            p_316766_.playSound((Player)null, p_316227_, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_316766_.setBlockAndUpdate(p_316227_, CandleTofuCakeBlock.byCandle((Block)candleblock, this));
            p_316766_.gameEvent((Entity)p_316853_, (Holder)GameEvent.BLOCK_CHANGE, p_316227_);
            p_316853_.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected InteractionResult useWithoutItem(BlockState p_316481_, Level p_316406_, BlockPos p_316218_, Player p_316212_, BlockHitResult p_316525_) {
        if (p_316406_.isClientSide) {
            if (TofuCakeBlock.eat((LevelAccessor)p_316406_, p_316218_, p_316481_, p_316212_).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (p_316212_.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return TofuCakeBlock.eat((LevelAccessor)p_316406_, p_316218_, p_316481_, p_316212_);
    }

    protected static InteractionResult eat(LevelAccessor p_51186_, BlockPos p_51187_, BlockState p_51188_, Player p_51189_) {
        if (!p_51189_.canEat(false)) {
            return InteractionResult.PASS;
        }
        p_51189_.awardStat(Stats.EAT_CAKE_SLICE);
        p_51189_.getFoodData().eat(2, 0.1f);
        int i = (Integer)p_51188_.getValue((Property)BITES);
        p_51186_.gameEvent((Entity)p_51189_, (Holder)GameEvent.EAT, p_51187_);
        if (i < 6) {
            p_51186_.setBlock(p_51187_, (BlockState)p_51188_.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            p_51186_.removeBlock(p_51187_, false);
            p_51186_.gameEvent((Entity)p_51189_, (Holder)GameEvent.BLOCK_DESTROY, p_51187_);
        }
        return InteractionResult.SUCCESS;
    }

    protected BlockState updateShape(BlockState p_51032_, LevelReader p_374532_, ScheduledTickAccess p_374466_, BlockPos p_51036_, Direction p_51033_, BlockPos p_51037_, BlockState p_51034_, RandomSource p_374272_) {
        return p_51033_ == Direction.DOWN && !p_51032_.canSurvive(p_374532_, p_51036_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_51032_, p_374532_, p_374466_, p_51036_, p_51033_, p_51037_, p_51034_, p_374272_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51220_) {
        p_51220_.add(new Property[]{BITES});
    }
}

