/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block.utils;

import baguchi.tofucraft.blockentity.TofuChestBlockEntity;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TofuChestBlock
extends AbstractChestBlock<TofuChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final MapCodec<TofuChestBlock> CODEC = TofuChestBlock.simpleCodec(p_304364_ -> new TofuChestBlock((BlockBehaviour.Properties)p_304364_, () -> (BlockEntityType)TofuBlockEntitys.TOFUCHEST.get()));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    protected static final int AABB_OFFSET = 1;
    protected static final int AABB_HEIGHT = 14;
    protected static final VoxelShape NORTH_AABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final DoubleBlockCombiner.Combiner<TofuChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<TofuChestBlockEntity, Optional<Container>>(){

        public Optional<Container> acceptDouble(TofuChestBlockEntity p_51591_, TofuChestBlockEntity p_51592_) {
            return Optional.of(new CompoundContainer((Container)p_51591_, (Container)p_51592_));
        }

        public Optional<Container> acceptSingle(TofuChestBlockEntity p_51589_) {
            return Optional.of(p_51589_);
        }

        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<TofuChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<TofuChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final TofuChestBlockEntity p_51604_, final TofuChestBlockEntity p_51605_) {
            CompoundContainer container = new CompoundContainer((Container)p_51604_, (Container)p_51605_);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu createMenu(int p_51622_, Inventory p_51623_, Player p_51624_) {
                    if (p_51604_.canOpen(p_51624_) && p_51605_.canOpen(p_51624_)) {
                        p_51604_.unpackLootTable(p_51623_.player);
                        p_51605_.unpackLootTable(p_51623_.player);
                        return ChestMenu.sixRows((int)p_51622_, (Inventory)p_51623_, (Container)this.val$container);
                    }
                    return null;
                }

                public Component getDisplayName() {
                    if (p_51604_.hasCustomName()) {
                        return p_51604_.getDisplayName();
                    }
                    return p_51605_.hasCustomName() ? p_51605_.getDisplayName() : Component.translatable((String)"container.chestDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(TofuChestBlockEntity p_51602_) {
            return Optional.of(p_51602_);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public TofuChestBlock(BlockBehaviour.Properties p_51490_, Supplier<BlockEntityType<? extends TofuChestBlockEntity>> p_51491_) {
        super(p_51490_, p_51491_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends AbstractChestBlock<TofuChestBlockEntity>> codec() {
        return CODEC;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState p_51583_) {
        ChestType chesttype = (ChestType)p_51583_.getValue(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    protected BlockState updateShape(BlockState stateIn, LevelReader levelReader, ScheduledTickAccess access, BlockPos currentPos, Direction direction, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            access.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        if (facingState.is((Block)this) && direction.getAxis().isHorizontal()) {
            ChestType chesttype = (ChestType)facingState.getValue(TYPE);
            if (stateIn.getValue(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && stateIn.getValue(FACING) == facingState.getValue(FACING) && TofuChestBlock.getConnectedDirection(facingState) == direction.getOpposite()) {
                return (BlockState)stateIn.setValue(TYPE, (Comparable)chesttype.getOpposite());
            }
        } else if (TofuChestBlock.getConnectedDirection(stateIn) == direction) {
            return (BlockState)stateIn.setValue(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.updateShape(stateIn, levelReader, access, currentPos, direction, facingPos, facingState, randomSource);
    }

    public VoxelShape getShape(BlockState p_51569_, BlockGetter p_51570_, BlockPos p_51571_, CollisionContext p_51572_) {
        if (p_51569_.getValue(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        switch (TofuChestBlock.getConnectedDirection(p_51569_)) {
            default: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public static Direction getConnectedDirection(BlockState p_51585_) {
        Direction direction = (Direction)p_51585_.getValue(FACING);
        return p_51585_.getValue(TYPE) == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_51493_) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = p_51493_.getHorizontalDirection().getOpposite();
        FluidState fluidstate = p_51493_.getLevel().getFluidState(p_51493_.getClickedPos());
        boolean flag = p_51493_.isSecondaryUseActive();
        Direction direction1 = p_51493_.getClickedFace();
        if (direction1.getAxis().isHorizontal() && flag && (direction2 = this.candidatePartnerFacing(p_51493_, direction1.getOpposite())) != null && direction2.getAxis() != direction1.getAxis()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.getCounterClockWise() == direction1.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.candidatePartnerFacing(p_51493_, direction.getClockWise())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(p_51493_, direction.getCounterClockWise())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction)).setValue(TYPE, (Comparable)chesttype)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState p_51581_) {
        return (Boolean)p_51581_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_51581_);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext p_51495_, Direction p_51496_) {
        BlockState blockstate = p_51495_.getLevel().getBlockState(p_51495_.getClickedPos().relative(p_51496_));
        return blockstate.is((Block)this) && blockstate.getValue(TYPE) == ChestType.SINGLE ? (Direction)blockstate.getValue(FACING) : null;
    }

    public void onRemove(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.is(p_51541_.getBlock())) {
            BlockEntity blockentity = p_51539_.getBlockEntity(p_51540_);
            if (blockentity instanceof Container) {
                Containers.dropContents((Level)p_51539_, (BlockPos)p_51540_, (Container)((Container)blockentity));
                p_51539_.updateNeighbourForOutputSignal(p_51540_, (Block)this);
            }
            super.onRemove(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    protected InteractionResult useWithoutItem(BlockState p_51531_, Level p_51532_, BlockPos p_51533_, Player p_51534_, BlockHitResult p_51536_) {
        if (p_51532_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuprovider = this.getMenuProvider(p_51531_, p_51532_, p_51533_);
        if (menuprovider != null) {
            p_51534_.openMenu(menuprovider);
            p_51534_.awardStat(this.getOpenChestStat());
            if (p_51532_ instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)p_51532_;
                PiglinAi.angerNearbyPiglins((ServerLevel)serverLevel, (Player)p_51534_, (boolean)true);
            }
        }
        return InteractionResult.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.OPEN_CHEST);
    }

    public BlockEntityType<? extends TofuChestBlockEntity> blockEntityType() {
        return (BlockEntityType)this.blockEntityType.get();
    }

    @Nullable
    public static Container getContainer(TofuChestBlock p_51512_, BlockState p_51513_, Level p_51514_, BlockPos p_51515_, boolean p_51516_) {
        return ((Optional)p_51512_.combine(p_51513_, p_51514_, p_51515_, p_51516_).apply(CHEST_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends TofuChestBlockEntity> combine(BlockState p_51544_, Level p_51545_, BlockPos p_51546_, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = p_51547_ ? (p_51578_, p_51579_) -> false : TofuChestBlock::isTofuChestBlockedAt;
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)this.blockEntityType.get()), TofuChestBlock::getBlockType, TofuChestBlock::getConnectedDirection, FACING, (BlockState)p_51544_, (LevelAccessor)p_51545_, (BlockPos)p_51546_, bipredicate);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState p_51574_, Level p_51575_, BlockPos p_51576_) {
        return ((Optional)this.combine(p_51574_, p_51575_, p_51576_, false).apply(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<TofuChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity p_51518_) {
        return new DoubleBlockCombiner.Combiner<TofuChestBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(TofuChestBlockEntity p_51633_, TofuChestBlockEntity p_51634_) {
                return p_51638_ -> Math.max(p_51633_.getOpenNess(p_51638_), p_51634_.getOpenNess(p_51638_));
            }

            public Float2FloatFunction acceptSingle(TofuChestBlockEntity p_51631_) {
                return arg_0 -> ((TofuChestBlockEntity)p_51631_).getOpenNess(arg_0);
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)p_51518_).getOpenNess(arg_0);
            }
        };
    }

    public BlockEntity newBlockEntity(BlockPos p_153064_, BlockState p_153065_) {
        return new TofuChestBlockEntity(p_153064_, p_153065_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153055_, BlockState p_153056_, BlockEntityType<T> p_153057_) {
        return p_153055_.isClientSide ? TofuChestBlock.createTickerHelper(p_153057_, this.blockEntityType(), ChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isTofuChestBlockedAt(LevelAccessor p_51509_, BlockPos p_51510_) {
        return TofuChestBlock.isBlockedChestByBlock((BlockGetter)p_51509_, p_51510_) || TofuChestBlock.isCatSittingOnChest(p_51509_, p_51510_);
    }

    private static boolean isBlockedChestByBlock(BlockGetter p_51500_, BlockPos p_51501_) {
        BlockPos blockpos = p_51501_.above();
        return p_51500_.getBlockState(blockpos).isRedstoneConductor(p_51500_, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor p_51564_, BlockPos p_51565_) {
        List list = p_51564_.getEntitiesOfClass(Cat.class, new AABB((double)p_51565_.getX(), (double)(p_51565_.getY() + 1), (double)p_51565_.getZ(), (double)(p_51565_.getX() + 1), (double)(p_51565_.getY() + 2), (double)(p_51565_.getZ() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState p_51520_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState p_51527_, Level p_51528_, BlockPos p_51529_) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)TofuChestBlock.getContainer(this, p_51527_, p_51528_, p_51529_, false));
    }

    public BlockState rotate(BlockState p_51552_, Rotation p_51553_) {
        return (BlockState)p_51552_.setValue(FACING, (Comparable)p_51553_.rotate((Direction)p_51552_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_51549_, Mirror p_51550_) {
        BlockState rotated = p_51549_.rotate(p_51550_.getRotation((Direction)p_51549_.getValue(FACING)));
        return p_51550_ == Mirror.NONE ? rotated : (BlockState)rotated.setValue(TYPE, (Comparable)((ChestType)rotated.getValue(TYPE)).getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51562_) {
        p_51562_.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }

    public void tick(BlockState p_153059_, ServerLevel p_153060_, BlockPos p_153061_, RandomSource p_153062_) {
        BlockEntity blockentity = p_153060_.getBlockEntity(p_153061_);
        if (blockentity instanceof TofuChestBlockEntity) {
            ((TofuChestBlockEntity)blockentity).recheckOpen();
        }
    }
}

