/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.blockentity;

import baguchi.tofucraft.block.TofunianStatueBlock;
import baguchi.tofucraft.blockentity.FoodPlateBlockEntity;
import baguchi.tofucraft.blockentity.SyncedBlockEntity;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.registry.TofuTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class TofunianStatueBlockEntity
extends SyncedBlockEntity {
    public static final ResourceKey<LootTable> LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"gameplay/tofunian_statue"));
    private int processTick;
    private long cooldown;
    private float happyScale;
    private long happyTime;

    public TofunianStatueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TofuBlockEntitys.TOFUNIAN_STATUE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockstate, TofunianStatueBlockEntity statue) {
        BlockPos platePos;
        BlockEntity blockEntity;
        if (!level.isClientSide() && statue.cooldown <= level.getGameTime() && (blockEntity = level.getBlockEntity(platePos = pos.relative((Direction)blockstate.getValue(TofunianStatueBlock.FACING)))) instanceof FoodPlateBlockEntity) {
            FoodPlateBlockEntity foodPlate = (FoodPlateBlockEntity)blockEntity;
            if (foodPlate.getStoredItem().is(TofuTags.Items.STATUE_HAPPY)) {
                if (++statue.processTick > 200) {
                    foodPlate.removeItem();
                    LootTable loottable = level.getServer().reloadableRegistries().getLootTable(LOOT_TABLE);
                    LootParams lootparams = new LootParams.Builder((ServerLevel)level).withLuck(statue.happyScale).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)platePos)).create(LootContextParamSets.CHEST);
                    ObjectArrayList objectarraylist = loottable.getRandomItems(lootparams);
                    foodPlate.addAllItem((ItemStack)objectarraylist.get(0));
                    statue.processTick = 0;
                    statue.cooldown = level.getGameTime() + 12000L + (long)level.random.nextInt(12000);
                    statue.happyTime = statue.getCooldown() + 24000L;
                    statue.happyScale = Mth.clamp((float)(statue.happyScale + 1.0f), (float)0.0f, (float)5.0f);
                    level.playSound(null, platePos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS);
                } else if (level.random.nextInt(4) == 0) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)TofuParticleTypes.TOFU_PORTAL.get(), (double)((float)platePos.getX() + 0.5f), (double)((float)platePos.getY() + 0.1f), (double)((float)platePos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 1.0);
                }
            } else {
                if (statue.happyTime < level.getGameTime()) {
                    statue.happyTime = 12000L + level.getGameTime();
                    statue.happyScale = Mth.clamp((float)(statue.happyScale - 0.25f), (float)0.0f, (float)5.0f);
                }
                statue.processTick = 0;
            }
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.setProcessTick(compound.getInt("ProcessTick"));
        this.setCooldown(compound.getLong("CooldownAt"));
        this.setHappyScale(compound.getFloat("HappyScale"));
        this.setHappyTime(compound.getLong("HappyTimeAt"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("ProcessTick", this.getProcessTick());
        compound.putLong("CooldownAt", this.getCooldown());
        compound.putFloat("HappyScale", this.getHappyScale());
        compound.putLong("HappyTimeAt", this.getHappyTime());
    }

    public int getProcessTick() {
        return this.processTick;
    }

    public void setProcessTick(int process) {
        this.processTick = process;
    }

    public void setHappyScale(float happyScale) {
        this.happyScale = happyScale;
    }

    public float getHappyScale() {
        return this.happyScale;
    }

    public void setHappyTime(long happyTime) {
        this.happyTime = happyTime;
    }

    public long getHappyTime() {
        return this.happyTime;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }
}

