/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.layer;

import baguchi.tofucraft.client.model.TofuGandlemModel;
import baguchi.tofucraft.client.render.state.TofuGandlemRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TofuGandlemEmissiveLayer<T extends TofuGandlemRenderState, M extends TofuGandlemModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AlphaFunction<T> alphaFunction;
    private final DrawSelector<T, M> drawSelector;

    public TofuGandlemEmissiveLayer(RenderLayerParent<T, M> p_234885_, ResourceLocation p_234886_, AlphaFunction<T> p_234887_, DrawSelector<T, M> p_234888_) {
        super(p_234885_);
        this.texture = p_234886_;
        this.alphaFunction = p_234887_;
        this.drawSelector = p_234888_;
    }

    private void onlyDrawSelectedParts() {
        List<ModelPart> list = this.drawSelector.getPartsToDraw((TofuGandlemModel)this.getParentModel());
        ((TofuGandlemModel)this.getParentModel()).root().getAllParts().forEach(p_234918_ -> {
            p_234918_.skipDraw = true;
        });
        list.forEach(p_234916_ -> {
            p_234916_.skipDraw = false;
        });
    }

    private void resetDrawForAllParts() {
        ((TofuGandlemModel)this.getParentModel()).root().getAllParts().forEach(p_234913_ -> {
            p_234913_.skipDraw = false;
        });
    }

    public void render(PoseStack p_117349_, MultiBufferSource p_117350_, int p_117351_, T p_361554_, float p_117353_, float p_117354_) {
        if (!((TofuGandlemRenderState)((Object)p_361554_)).isInvisible) {
            this.onlyDrawSelectedParts();
            VertexConsumer vertexconsumer = p_117350_.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)this.texture));
            ((TofuGandlemModel)this.getParentModel()).renderToBuffer(p_117349_, vertexconsumer, p_117351_, LivingEntityRenderer.getOverlayCoords(p_361554_, (float)0.0f));
            this.resetDrawForAllParts();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AlphaFunction<T extends TofuGandlemRenderState> {
        public float apply(T var1, float var2, float var3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface DrawSelector<T extends TofuGandlemRenderState, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

