/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data;

import baguchi.tofucraft.data.TofuDamageTypeTags;
import baguchi.tofucraft.data.TofuLootTableProvider;
import baguchi.tofucraft.data.generator.BiomeTagGenerator;
import baguchi.tofucraft.data.generator.BlockTagGenerator;
import baguchi.tofucraft.data.generator.CustomTagGenerator;
import baguchi.tofucraft.data.generator.EnchantTagGenerator;
import baguchi.tofucraft.data.generator.EntityTagGenerator;
import baguchi.tofucraft.data.generator.FluidTagGenerator;
import baguchi.tofucraft.data.generator.ItemTagGenerator;
import baguchi.tofucraft.data.generator.RegistryDataGenerator;
import baguchi.tofucraft.data.generator.TofuAdvancementGenerator;
import baguchi.tofucraft.data.generator.TofuDataMapsProvider;
import baguchi.tofucraft.data.generator.TofuEquipmentModelProvider;
import baguchi.tofucraft.data.generator.TofuModelData;
import baguchi.tofucraft.data.generator.recipe.CraftingGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="tofucraft", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(true, (DataProvider)datapackProvider);
        generator.addProvider(true, (DataProvider)new TofuModelData(packOutput));
        generator.addProvider(true, (DataProvider)new TofuEquipmentModelProvider(packOutput));
        BlockTagGenerator blocktags = new BlockTagGenerator(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blocktags);
        generator.addProvider(true, (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blocktags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new EntityTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TofuDamageTypeTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new EnchantTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CustomTagGenerator.BannerPatternTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CustomTagGenerator.PoiTypeTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CustomTagGenerator.SoundEventTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new BiomeTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new FluidTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)TofuLootTableProvider.create(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TofuAdvancementGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TofuDataMapsProvider(packOutput, lookupProvider));
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new CraftingGenerator(lookupProvider, output);
        }

        public String getName() {
            return "tofucraftrecipes";
        }
    }
}

