/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.provider;

import baguchi.tofucraft.client.render.special.TofunianStatueSpecialRenderer;
import baguchi.tofucraft.data.provider.TofuModelTemplate;
import baguchi.tofucraft.data.provider.TofuTextureMapping;
import baguchi.tofucraft.registry.TofuBlocks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.color.item.GrassColorSource;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.blockstates.BlockStateGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.special.BedSpecialRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class TofuBlockstateModelProvider
extends BlockModelGenerators {
    public static final ModelTemplate GLOW_CUBE = TofuModelTemplate.GLOW_CUBE.extend().renderType("cutout").build();
    public static final ModelTemplate TRANSLUCENT_CUBE = ModelTemplates.CUBE_ALL.extend().renderType("translucent").build();
    public static final ModelTemplate CUTOUT_CUBE = ModelTemplates.CUBE_ALL.extend().renderType("cutout").build();
    public static final ModelTemplate CROP = ModelTemplates.CROP.extend().renderType("cutout").build();
    public static final TexturedModel.Provider LEAVES_PROVIDER = TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)ModelTemplates.LEAVES.extend().renderType("cutout").build());
    public static final TexturedModel.Provider CHAIN = TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)TofuModelTemplate.CHAIN.extend().renderType("cutout").build());
    public static final TexturedModel.Provider LANTERN = TexturedModel.createDefault(TextureMapping::lantern, (ModelTemplate)ModelTemplates.LANTERN.extend().renderType("cutout").build());
    public static final TexturedModel.Provider HANGING_LANTERN = TexturedModel.createDefault(TextureMapping::lantern, (ModelTemplate)ModelTemplates.HANGING_LANTERN.extend().renderType("cutout").build());

    public TofuBlockstateModelProvider(Consumer<BlockStateGenerator> blockStateOutput, ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(blockStateOutput, itemModelOutput, modelOutput);
    }

    public void createTrapdoor(Block p_387551_) {
        TextureMapping texturemapping = TextureMapping.defaultTexture((Block)p_387551_);
        ResourceLocation resourcelocation = ModelTemplates.TRAPDOOR_TOP.extend().renderType("cutout").build().create(p_387551_, texturemapping, this.modelOutput);
        ResourceLocation resourcelocation1 = ModelTemplates.TRAPDOOR_BOTTOM.extend().renderType("cutout").build().create(p_387551_, texturemapping, this.modelOutput);
        ResourceLocation resourcelocation2 = ModelTemplates.TRAPDOOR_OPEN.extend().renderType("cutout").build().create(p_387551_, texturemapping, this.modelOutput);
        this.blockStateOutput.accept(TofuBlockstateModelProvider.createTrapdoor((Block)p_387551_, (ResourceLocation)resourcelocation, (ResourceLocation)resourcelocation1, (ResourceLocation)resourcelocation2));
        this.registerSimpleItemModel(p_387551_, resourcelocation1.withSuffix(""));
    }

    public void createCropBlock(Block p_387553_, Property<Integer> p_386757_, int ... p_388514_) {
        if (p_386757_.getPossibleValues().size() != p_388514_.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        PropertyDispatch propertydispatch = PropertyDispatch.property(p_386757_).generate(arg_0 -> this.lambda$createCropBlock$1(p_388514_, (Int2ObjectMap)int2objectmap, p_387553_, arg_0));
        this.registerSimpleFlatItemModel(p_387553_.asItem());
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)p_387553_).with(propertydispatch));
    }

    public void createOrientableTrapdoor(Block p_388937_) {
        TextureMapping texturemapping = TextureMapping.defaultTexture((Block)p_388937_);
        ResourceLocation resourcelocation = ModelTemplates.ORIENTABLE_TRAPDOOR_TOP.extend().renderType("cutout").build().create(p_388937_, texturemapping, this.modelOutput);
        ResourceLocation resourcelocation1 = ModelTemplates.ORIENTABLE_TRAPDOOR_BOTTOM.extend().renderType("cutout").build().create(p_388937_, texturemapping, this.modelOutput);
        ResourceLocation resourcelocation2 = ModelTemplates.ORIENTABLE_TRAPDOOR_OPEN.extend().renderType("cutout").build().create(p_388937_, texturemapping, this.modelOutput);
        this.blockStateOutput.accept(TofuBlockstateModelProvider.createOrientableTrapdoor((Block)p_388937_, (ResourceLocation)resourcelocation, (ResourceLocation)resourcelocation1, (ResourceLocation)resourcelocation2));
        this.registerSimpleItemModel(p_388937_, resourcelocation1.withSuffix(""));
    }

    public void createDoor(Block block) {
        TextureMapping bottomMapping = TofuTextureMapping.doorBottom(block);
        TextureMapping topMapping = TofuTextureMapping.doorTop(block);
        ResourceLocation left = ModelTemplates.DOOR_BOTTOM_LEFT.extend().renderType("cutout").build().create(block, bottomMapping, this.modelOutput);
        ResourceLocation bottomLeftOpen = ModelTemplates.DOOR_BOTTOM_LEFT_OPEN.extend().renderType("cutout").build().create(block, bottomMapping, this.modelOutput);
        ResourceLocation bottomRight = ModelTemplates.DOOR_BOTTOM_RIGHT.extend().renderType("cutout").build().create(block, bottomMapping, this.modelOutput);
        ResourceLocation bottomRightOpen = ModelTemplates.DOOR_BOTTOM_RIGHT_OPEN.extend().renderType("cutout").build().create(block, bottomMapping, this.modelOutput);
        ResourceLocation topLeft = ModelTemplates.DOOR_TOP_LEFT.extend().renderType("cutout").build().create(block, topMapping, this.modelOutput);
        ResourceLocation topLeftOpen = ModelTemplates.DOOR_TOP_LEFT_OPEN.extend().renderType("cutout").build().create(block, topMapping, this.modelOutput);
        ResourceLocation topRight = ModelTemplates.DOOR_TOP_RIGHT.extend().renderType("cutout").build().create(block, topMapping, this.modelOutput);
        ResourceLocation topRightOpen = ModelTemplates.DOOR_TOP_RIGHT_OPEN.extend().renderType("cutout").build().create(block, topMapping, this.modelOutput);
        this.registerSimpleFlatItemModel(block.asItem());
        this.blockStateOutput.accept(TofuBlockstateModelProvider.createDoor((Block)block, (ResourceLocation)left, (ResourceLocation)bottomLeftOpen, (ResourceLocation)bottomRight, (ResourceLocation)bottomRightOpen, (ResourceLocation)topLeft, (ResourceLocation)topLeftOpen, (ResourceLocation)topRight, (ResourceLocation)topRightOpen));
    }

    public void createLadder(Block p_387133_) {
        TextureMapping texturemapping = TextureMapping.cube((Block)p_387133_);
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)p_387133_, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)TofuModelTemplate.LADDER.create(p_387133_, texturemapping, this.modelOutput))).with(TofuBlockstateModelProvider.createHorizontalFacingDispatch()));
        this.registerSimpleFlatItemModel(p_387133_);
    }

    public void createLantern(Block p_386669_) {
        ResourceLocation resourcelocation = LANTERN.create(p_386669_, this.modelOutput);
        ResourceLocation resourcelocation1 = HANGING_LANTERN.create(p_386669_, this.modelOutput);
        this.registerSimpleFlatItemModel(p_386669_.asItem());
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)p_386669_).with(TofuBlockstateModelProvider.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.HANGING, (ResourceLocation)resourcelocation1, (ResourceLocation)resourcelocation)));
    }

    public void createItemWithDoubleGrassTint(Block p_388714_) {
        this.registerSimpleTintedItemModel(p_388714_, ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Block)p_388714_), TextureMapping.layer0((ResourceLocation)TextureMapping.getBlockTexture((Block)p_388714_).withSuffix("_top")), this.modelOutput), (ItemTintSource)new GrassColorSource());
    }

    public void createTintedDoublePlant(Block p_388276_) {
        this.createItemWithDoubleGrassTint(p_388276_);
        this.createDoublePlant(p_388276_, BlockModelGenerators.PlantType.TINTED);
    }

    public void createDoublePlant(Block p_388543_, BlockModelGenerators.PlantType p_388551_) {
        ResourceLocation resourcelocation = this.createSuffixedVariant(p_388543_, "_top", (ModelTemplate)p_388551_.getCross().extend().renderType("cutout").build(), TextureMapping::cross);
        ResourceLocation resourcelocation1 = this.createSuffixedVariant(p_388543_, "_bottom", (ModelTemplate)p_388551_.getCross().extend().renderType("cutout").build(), TextureMapping::cross);
        this.createDoubleBlock(p_388543_, resourcelocation, resourcelocation1);
    }

    public void createTrivialCube(Block p_386512_) {
        this.createTrivialBlock(p_386512_, TexturedModel.CUBE);
    }

    public void createTrivialBlock(Block p_387678_, TexturedModel.Provider p_386545_) {
        this.blockStateOutput.accept(TofuBlockstateModelProvider.createSimpleBlock(p_387678_, p_386545_.create(p_387678_, this.modelOutput)));
    }

    public void logWithHorizontal(Block p_387121_) {
        ResourceLocation resourcelocation = ModelTemplates.CUBE_COLUMN.create(p_387121_, TextureMapping.logColumn((Block)p_387121_), this.modelOutput);
        ResourceLocation resourcelocation1 = ModelTemplates.CUBE_COLUMN_HORIZONTAL.create(p_387121_, TextureMapping.logColumn((Block)p_387121_), this.modelOutput);
        this.blockStateOutput.accept(BlockModelGenerators.createRotatedPillarWithHorizontalVariant((Block)p_387121_, (ResourceLocation)resourcelocation, (ResourceLocation)resourcelocation1));
    }

    public void logWithHorizontalGlow(Block p_387121_) {
        ResourceLocation resourcelocation = TofuModelTemplate.CUBE_COLUMN.create(p_387121_, TofuTextureMapping.logGlowColumn(p_387121_), this.modelOutput);
        ResourceLocation resourcelocation1 = TofuModelTemplate.CUBE_COLUMN_HORIZONTAL.create(p_387121_, TofuTextureMapping.logGlowColumn(p_387121_), this.modelOutput);
        this.blockStateOutput.accept(BlockModelGenerators.createRotatedPillarWithHorizontalVariant((Block)p_387121_, (ResourceLocation)resourcelocation, (ResourceLocation)resourcelocation1));
    }

    public void createCrossBlock(Block p_388178_, BlockModelGenerators.PlantType p_387157_) {
        TextureMapping texturemapping = p_387157_.getTextureMapping(p_388178_);
        this.createCrossBlock(p_388178_, p_387157_, texturemapping);
    }

    public void createCrossBlock(Block p_388360_, BlockModelGenerators.PlantType p_386631_, TextureMapping p_388352_) {
        ResourceLocation resourcelocation = p_386631_.getCross().extend().renderType("cutout").build().create(p_388360_, p_388352_, this.modelOutput);
        this.blockStateOutput.accept(TofuBlockstateModelProvider.createSimpleBlock(p_388360_, resourcelocation));
    }

    public void createCutoutCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)CUTOUT_CUBE.create(block, TextureMapping.cube((Block)block), this.modelOutput)));
    }

    public void createSingleCrop(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)CROP.create(block, TextureMapping.crop((ResourceLocation)TextureMapping.getBlockTexture((Block)block)), this.modelOutput)));
    }

    public void createTranslucentCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)TRANSLUCENT_CUBE.create(block, TextureMapping.cube((Block)block), this.modelOutput)));
    }

    public void createGlowCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)GLOW_CUBE.create(block, TofuTextureMapping.glowCube(block), this.modelOutput)));
    }

    public void createTofuCandleCake(Block candle, Block cake, Block defaultCake) {
        ResourceLocation resourcelocation8 = ModelTemplates.CANDLE_CAKE.create(cake, TofuTextureMapping.candleCake(candle, defaultCake, false), this.modelOutput);
        ResourceLocation resourcelocation9 = ModelTemplates.CANDLE_CAKE.createWithSuffix(cake, "_lit", TofuTextureMapping.candleCake(candle, defaultCake, false), this.modelOutput);
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)cake).with(TofuBlockstateModelProvider.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (ResourceLocation)resourcelocation9, (ResourceLocation)resourcelocation8)));
    }

    public static String getBlockName(Block p_387523_) {
        ResourceLocation resourcelocation = BuiltInRegistries.BLOCK.getKey((Object)p_387523_);
        return resourcelocation.getPath();
    }

    public void createTofuFarmland() {
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)((Block)TofuBlocks.TOFU_TERRAIN.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)TofuBlocks.TOFU_FARMLAND.get())));
        TextureMapping texturemapping1 = new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)((Block)TofuBlocks.TOFU_TERRAIN.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)TofuBlocks.TOFU_FARMLAND.get()), (String)"_moist"));
        ResourceLocation resourcelocation = ModelTemplates.FARMLAND.create((Block)TofuBlocks.TOFU_FARMLAND.get(), texturemapping, this.modelOutput);
        ResourceLocation resourcelocation1 = ModelTemplates.FARMLAND.create(TextureMapping.getBlockTexture((Block)((Block)TofuBlocks.TOFU_FARMLAND.get()), (String)"_moist"), texturemapping1, this.modelOutput);
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)TofuBlocks.TOFU_FARMLAND.get())).with(BlockModelGenerators.createEmptyOrFullDispatch((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7), (ResourceLocation)resourcelocation1, (ResourceLocation)resourcelocation)));
    }

    public static MultiVariantGenerator createSimpleBlock(Block p_387997_, ResourceLocation p_388814_) {
        return MultiVariantGenerator.multiVariant((Block)p_387997_, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)p_388814_));
    }

    public void createTofuPortalBlock() {
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)TofuBlocks.TOFU_PORTAL.get())).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_AXIS).select((Comparable)Direction.Axis.X, Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)((Block)TofuBlocks.TOFU_PORTAL.get()), (String)"_ns"))).select((Comparable)Direction.Axis.Z, Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)((Block)TofuBlocks.TOFU_PORTAL.get()), (String)"_ew")))));
    }

    public void createTofuCakeBlock(Block block) {
        this.registerSimpleFlatItemModel(block.asItem());
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.BITES).select((Comparable)Integer.valueOf(0), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block))).select((Comparable)Integer.valueOf(1), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_slice1"))).select((Comparable)Integer.valueOf(2), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_slice2"))).select((Comparable)Integer.valueOf(3), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_slice3"))).select((Comparable)Integer.valueOf(4), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_slice4"))).select((Comparable)Integer.valueOf(5), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_slice5"))).select((Comparable)Integer.valueOf(6), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_slice6")))));
    }

    public void createTofuBed(Block p_387718_, Block p_386452_, ResourceLocation p_387181_) {
        ResourceLocation resourcelocation = ModelLocationUtils.decorateBlockModelLocation((String)"bed");
        this.blockStateOutput.accept(TofuBlockstateModelProvider.createSimpleBlock(p_387718_, resourcelocation));
        Item item = p_387718_.asItem();
        ResourceLocation resourcelocation1 = ModelTemplates.BED_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.particle((Block)p_386452_), this.modelOutput);
        this.itemModelOutput.accept(item, ItemModelUtils.specialModel((ResourceLocation)resourcelocation1, (SpecialModelRenderer.Unbaked)new BedSpecialRenderer.Unbaked(p_387181_)));
    }

    public void createTofunianState(Block p_387718_, Block p_386452_) {
        this.createParticleOnlyBlock(p_387718_, p_386452_);
        Item item = p_387718_.asItem();
        ResourceLocation resourcelocation1 = ModelTemplates.BED_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.particle((Block)p_386452_), this.modelOutput);
        this.itemModelOutput.accept(item, ItemModelUtils.specialModel((ResourceLocation)resourcelocation1, (SpecialModelRenderer.Unbaked)new TofunianStatueSpecialRenderer.Unbaked()));
    }

    private /* synthetic */ Variant lambda$createCropBlock$1(int[] p_388514_, Int2ObjectMap int2objectmap, Block p_387553_, Integer p_388091_) {
        int i = p_388514_[p_388091_];
        ResourceLocation resourcelocation = (ResourceLocation)int2objectmap.computeIfAbsent(i, p_387534_ -> this.createSuffixedVariant(p_387553_, "_" + i, (ModelTemplate)ModelTemplates.CROP.extend().renderType("cutout").build(), TextureMapping::crop));
        return Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation);
    }
}

