/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import baguchi.tofucraft.entity.TofuGandlem;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChargeGoal
extends Goal {
    private final TofuGandlem gandlem;
    private int attackTime;
    private int cooldown;
    private int maxCooldown;
    private final UniformInt timeBetweenCooldown;

    public ChargeGoal(TofuGandlem p_32247_, UniformInt rushCooldown) {
        this.gandlem = p_32247_;
        this.timeBetweenCooldown = rushCooldown;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.maxCooldown <= 0) {
            this.maxCooldown = this.timeBetweenCooldown.sample(this.gandlem.getRandom());
            return false;
        }
        if (this.cooldown > this.maxCooldown) {
            if (this.gandlem.getHealth() < this.gandlem.getMaxHealth() / 2.0f && !this.gandlem.isRush()) {
                this.cooldown = 0;
                this.maxCooldown = this.timeBetweenCooldown.sample(this.gandlem.getRandom());
                return true;
            }
        } else {
            ++this.cooldown;
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.gandlem.isChargeFailed() && (this.gandlem.getAction() == TofuGandlem.Actions.CHARGE || this.gandlem.getAction() == TofuGandlem.Actions.CHARGE_STOP);
    }

    public void start() {
        super.start();
        this.gandlem.setAction(TofuGandlem.Actions.CHARGE);
        this.attackTime = 0;
        this.gandlem.setCharging(true);
        this.gandlem.playSound(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, 2.0f, 1.0f);
    }

    public void tick() {
        super.tick();
        ++this.attackTime;
        if (this.attackTime == 59) {
            this.gandlem.setCharging(false);
            this.gandlem.setAction(TofuGandlem.Actions.CHARGE_STOP);
            this.gandlem.setFullCharge(true);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

