/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import baguchi.tofucraft.block.crop.SoybeanCropsBlock;
import baguchi.tofucraft.entity.Tofunian;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;

public class CropHarvestGoal
extends MoveToBlockGoal {
    private final Tofunian tofunian;
    private boolean wantsToHarvest;
    private boolean canHarvest;
    private boolean canPlant;

    public CropHarvestGoal(Tofunian tofunianIn, double speed) {
        super((PathfinderMob)tofunianIn, speed, 8);
        this.tofunian = tofunianIn;
    }

    public boolean canUse() {
        if (this.nextStartTick <= 0) {
            if (!EventHooks.canEntityGrief((ServerLevel)((ServerLevel)this.tofunian.level()), (Entity)this.tofunian)) {
                return false;
            }
            this.canHarvest = false;
            this.canPlant = false;
            this.wantsToHarvest = true;
        }
        return this.tofunian.level().isDay() && this.tofunian.getRole() == Tofunian.Roles.TOFUCOOK && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.tofunian.level().isDay() && (this.canHarvest || this.canPlant || this.wantsToHarvest) && super.canContinueToUse();
    }

    public void start() {
        super.start();
        this.nextStartTick = 0;
        this.canHarvest = false;
        this.canPlant = false;
        this.wantsToHarvest = true;
    }

    public void tick() {
        super.tick();
        this.tofunian.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.tofunian.getMaxHeadXRot());
        if (this.isReachedTarget()) {
            Integer integer;
            Level world = this.tofunian.level();
            BlockPos blockpos = this.blockPos.above();
            BlockState blockstate = world.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            if (this.canHarvest && block instanceof CropBlock && (integer = (Integer)blockstate.getValue((Property)CropBlock.AGE)) == 7) {
                world.destroyBlock(blockpos, true);
            }
            BlockState blockstate2 = world.getBlockState(this.blockPos);
            ItemStack stack = this.findSeeds(this.tofunian);
            if (this.canPlant && blockstate2.getBlock() == TofuBlocks.TOFU_FARMLAND.get() && !stack.isEmpty()) {
                world.setBlock(this.blockPos.above(), ((Block)TofuBlocks.SOYBEAN.get()).defaultBlockState(), 2);
                stack.shrink(1);
            }
            this.canPlant = false;
            this.canHarvest = false;
            this.nextStartTick = 10;
        }
        if (this.wantsToHarvest && !this.canPlant && !this.canHarvest && --this.nextStartTick <= 0) {
            if (this.findNearestBlock()) {
                this.canPlant = true;
                this.canHarvest = true;
            } else {
                this.wantsToHarvest = false;
            }
        }
    }

    protected boolean isValidTarget(LevelReader p_179488_1_, BlockPos p_179488_2_) {
        Block block = p_179488_1_.getBlockState(p_179488_2_).getBlock();
        if (block == TofuBlocks.TOFU_FARMLAND.get() && this.wantsToHarvest) {
            BlockState blockstate = p_179488_1_.getBlockState(p_179488_2_ = p_179488_2_.above());
            block = blockstate.getBlock();
            if (block instanceof SoybeanCropsBlock && ((SoybeanCropsBlock)block).isMaxAge(blockstate)) {
                this.canHarvest = true;
                this.canPlant = true;
                return true;
            }
            if (!this.findSeeds(this.tofunian).isEmpty() && blockstate.isAir()) {
                this.canHarvest = true;
                this.canPlant = true;
                return true;
            }
        }
        return false;
    }

    private ItemStack findSeeds(Tofunian tofunian) {
        SimpleContainer inventory = tofunian.getInventory();
        int i = inventory.getContainerSize();
        for (int j = 0; j < i; ++j) {
            ItemStack itemstack = inventory.getItem(j);
            if (itemstack.getItem() != TofuItems.SEEDS_SOYBEANS.get()) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }
}

