/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import baguchi.tofucraft.entity.Tofunian;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class ShareItemAndGossipGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreInvisibilityTesting();
    protected final Tofunian tofunian;
    protected final double speedModifier;
    protected int nextStartTick;
    protected Tofunian partner;
    private boolean needPassed;
    private boolean alreadyGossiped;
    private int tryingTalkingTick;

    public ShareItemAndGossipGoal(Tofunian entity, double speed) {
        this.tofunian = entity;
        this.speedModifier = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.tofunian.level().isDay() && !this.tofunian.isBaby()) {
            this.nextStartTick = this.tofunian.getRandom().nextInt(200) + 200;
            this.partner = this.getFreePartner();
            return this.partner != null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.tryingTalkingTick < 300 && this.partner != null && this.partner.isAlive() && this.tofunian.distanceToSqr((Entity)this.partner) < 64.0;
    }

    public void start() {
        if (this.partner.wantsMoreFood() && this.tofunian.hasExcessFood()) {
            this.needPassed = true;
        }
    }

    public void stop() {
        super.stop();
        this.tryingTalkingTick = 0;
        this.alreadyGossiped = false;
    }

    @Nullable
    private Tofunian getFreePartner() {
        List list = this.tofunian.level().getEntitiesOfClass(Tofunian.class, this.tofunian.getBoundingBox().inflate(8.0), tofunian1 -> tofunian1 != this.tofunian);
        double d0 = Double.MAX_VALUE;
        Tofunian tofunian2 = null;
        for (Tofunian tofunianEntity1 : list) {
            if (!(this.tofunian.distanceToSqr((Entity)tofunianEntity1) < d0)) continue;
            tofunian2 = tofunianEntity1;
            d0 = this.tofunian.distanceToSqr((Entity)tofunianEntity1);
        }
        return tofunian2;
    }

    public void tick() {
        super.tick();
        ++this.tryingTalkingTick;
        if (this.tofunian.hasLineOfSight((Entity)this.partner)) {
            if (this.tofunian.distanceToSqr((Entity)this.partner) < 6.0) {
                this.tofunian.getLookControl().setLookAt((Entity)this.partner, 30.0f, 30.0f);
                this.tofunian.getNavigation().stop();
                if (this.needPassed) {
                    ShareItemAndGossipGoal.throwHalfStack(this.tofunian, Tofunian.FOOD_POINTS.keySet(), (LivingEntity)this.partner);
                    this.needPassed = false;
                    this.tofunian.level().broadcastEntityEvent((Entity)this.tofunian, (byte)5);
                    this.partner.setAction(Tofunian.Actions.HAPPY);
                }
                if (!this.alreadyGossiped) {
                    if (this.tofunian.level() instanceof ServerLevel) {
                        this.tofunian.gossip((ServerLevel)this.tofunian.level(), this.partner, this.tofunian.level().getGameTime());
                    }
                    this.alreadyGossiped = true;
                }
            } else {
                this.tofunian.getNavigation().moveTo((Entity)this.partner, 1.0);
                this.tofunian.getLookControl().setLookAt((Entity)this.partner, 30.0f, 30.0f);
            }
        } else {
            this.tofunian.getNavigation().moveTo((Entity)this.partner, 1.0);
        }
    }

    private static void throwHalfStack(Tofunian p_220586_0_, Set<Item> p_220586_1_, LivingEntity p_220586_2_) {
        SimpleContainer inventory = p_220586_0_.getInventory();
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            int j;
            Item item;
            ItemStack itemstack1 = inventory.getItem(i);
            if (itemstack1.isEmpty() || !p_220586_1_.contains(item = itemstack1.getItem())) continue;
            if (itemstack1.getCount() > itemstack1.getMaxStackSize() / 2) {
                j = itemstack1.getCount() / 2;
            } else {
                if (itemstack1.getCount() <= 24) continue;
                j = itemstack1.getCount() - 24;
            }
            itemstack1.shrink(j);
            itemstack = new ItemStack((ItemLike)item, j);
            break;
        }
        if (!itemstack.isEmpty()) {
            BehaviorUtils.throwItem((LivingEntity)p_220586_0_, (ItemStack)itemstack, (Vec3)p_220586_2_.position());
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

