/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class TofuDoorInteractGoal
extends Goal {
    protected Mob mob;
    protected BlockPos doorPos = BlockPos.ZERO;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public TofuDoorInteractGoal(Mob p_25193_) {
        this.mob = p_25193_;
        if (!GoalUtils.hasGroundPathNavigation((Mob)p_25193_)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.mob.level().getBlockState(this.doorPos);
        if (!(blockstate.getBlock() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.getValue((Property)DoorBlock.OPEN);
    }

    protected void setOpen(boolean p_25196_) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.mob.level().getBlockState(this.doorPos)).getBlock() instanceof DoorBlock) {
            ((DoorBlock)blockstate.getBlock()).setOpen((Entity)this.mob, this.mob.level(), blockstate, this.doorPos, p_25196_);
        }
    }

    public boolean canUse() {
        if (!GoalUtils.hasGroundPathNavigation((Mob)this.mob)) {
            return false;
        }
        if (!this.mob.horizontalCollision) {
            return false;
        }
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.mob.getNavigation();
        Path path = groundpathnavigation.getPath();
        if (path != null && !path.isDone()) {
            for (int i = 0; i < Math.min(path.getNextNodeIndex() + 2, path.getNodeCount()); ++i) {
                Node node = path.getNode(i);
                this.doorPos = new BlockPos(node.x, node.y + 1, node.z);
                if (this.mob.distanceToSqr((double)this.doorPos.getX(), this.mob.getY(), (double)this.doorPos.getZ()) > 2.25) continue;
                this.hasDoor = TofuDoorInteractGoal.isWoodenDoorOrTofuDoor(this.mob.level(), this.doorPos);
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.mob.blockPosition().above();
            this.hasDoor = TofuDoorInteractGoal.isWoodenDoorOrTofuDoor(this.mob.level(), this.doorPos);
            return this.hasDoor;
        }
        return false;
    }

    public static boolean isWoodenDoorOrTofuDoor(Level p_52746_, BlockPos p_52747_) {
        return DoorBlock.isWoodenDoor((BlockState)p_52746_.getBlockState(p_52747_)) || TofuDoorInteractGoal.isTofuDoor(p_52746_.getBlockState(p_52747_));
    }

    public static boolean isTofuDoor(BlockState p_52818_) {
        return p_52818_.getBlock() instanceof DoorBlock;
    }

    public boolean canContinueToUse() {
        return !this.passed;
    }

    public void start() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.getX() + 0.5 - this.mob.getX());
        this.doorOpenDirZ = (float)((double)this.doorPos.getZ() + 0.5 - this.mob.getZ());
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        float f1;
        float f = (float)((double)this.doorPos.getX() + 0.5 - this.mob.getX());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.getZ() + 0.5 - this.mob.getZ()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }
}

