/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.projectile;

import baguchi.tofucraft.registry.TofuDamageTypes;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuSounds;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FukumameEntity
extends ThrowableProjectile {
    public float damage = 1.0f;
    private int totalHits;
    @Nullable
    protected ItemStack firedFromWeapon = null;

    public FukumameEntity(EntityType<? extends FukumameEntity> p_i50154_1_, Level p_i50154_2_) {
        super(p_i50154_1_, p_i50154_2_);
    }

    public FukumameEntity(Level worldIn, LivingEntity throwerIn) {
        super(TofuEntityTypes.FUKUMAME.get(), throwerIn.getX(), throwerIn.getEyeY(), throwerIn.getZ(), worldIn);
        this.setOwner((Entity)throwerIn);
    }

    public FukumameEntity(Level worldIn, LivingEntity throwerIn, ItemStack stack) {
        super(TofuEntityTypes.FUKUMAME.get(), throwerIn.getX(), throwerIn.getEyeY(), throwerIn.getZ(), worldIn);
        this.setOwner((Entity)throwerIn);
        this.firedFromWeapon = stack.copy();
    }

    public FukumameEntity(Level worldIn, double x, double y, double z) {
        super(TofuEntityTypes.FUKUMAME.get(), x, y, z, worldIn);
    }

    public FukumameEntity(EntityType<? extends FukumameEntity> p_i50154_1_, Level worldIn, double x, double y, double z) {
        super(p_i50154_1_, x, y, z, worldIn);
    }

    public FukumameEntity(EntityType<? extends FukumameEntity> entityType, LivingEntity throwerIn, Level worldIn) {
        super(entityType, throwerIn.getX(), throwerIn.getEyeY(), throwerIn.getZ(), worldIn);
        this.setOwner((Entity)throwerIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 6; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)TofuItems.SEEDS_SOYBEANS.get())), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult p_37404_) {
        super.onHitEntity(p_37404_);
        Entity entity = p_37404_.getEntity();
        DamageSource damagesource = this.damageSources().source(TofuDamageTypes.FUKUMAME, (Entity)this, this.getOwner());
        double d0 = this.damage;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.getWeaponItem() != null) {
                d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)((float)d0));
            }
            if (entity.hurtServer(serverlevel, damagesource, (float)d0)) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity, (DamageSource)damagesource);
            }
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void hitBlockEnchantmentEffects(ServerLevel p_345462_, BlockHitResult p_345204_, ItemStack p_345083_) {
        LivingEntity livingentity;
        Vec3 vec3 = p_345204_.getBlockPos().clampLocationWithin(p_345204_.getLocation());
        Entity entity = this.getOwner();
        EnchantmentHelper.onHitBlock((ServerLevel)p_345462_, (ItemStack)p_345083_, (LivingEntity)(entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)vec3, (BlockState)p_345462_.getBlockState(p_345204_.getBlockPos()), p_348569_ -> {
            this.firedFromWeapon = null;
        });
    }

    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected void onHit(HitResult p_37406_) {
        super.onHit(p_37406_);
        this.playSound(TofuSounds.SOYBEAN_CRACK.get(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        ItemStack itemstack = this.getWeaponItem();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (itemstack != null) {
                this.hitBlockEnchantmentEffects(serverlevel, result, itemstack);
            }
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public void addAdditionalSaveData(CompoundTag p_37222_) {
        super.addAdditionalSaveData(p_37222_);
        p_37222_.putFloat("Damage", (float)((byte)this.damage));
        p_37222_.putInt("TotalHits", this.totalHits);
        if (this.firedFromWeapon != null) {
            p_37222_.put("weapon", this.firedFromWeapon.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag p_37220_) {
        super.readAdditionalSaveData(p_37220_);
        if (p_37220_.contains("Damage", 99)) {
            this.damage = p_37220_.getFloat("Damage");
        }
        this.totalHits = p_37220_.getInt("TotalHits");
        this.firedFromWeapon = p_37220_.contains("weapon", 10) ? (ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)p_37220_.getCompound("weapon")).orElse(null) : null;
    }
}

