/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.projectile;

import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuParticleTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class NattoBallEntity
extends ThrowableProjectile {
    public NattoBallEntity(EntityType<? extends NattoBallEntity> p_36892_, Level p_36893_) {
        super(p_36892_, p_36893_);
    }

    public NattoBallEntity(Level worldIn, LivingEntity throwerIn) {
        super(TofuEntityTypes.NATTO_STRNIG.get(), throwerIn.getX(), throwerIn.getEyeY(), throwerIn.getZ(), worldIn);
        this.setOwner((Entity)throwerIn);
    }

    protected boolean canHitEntity(Entity p_37250_) {
        return false;
    }

    protected void onHit(HitResult p_36913_) {
        super.onHit(p_36913_);
        if (!(p_36913_.getType() == HitResult.Type.ENTITY && this.ownedBy(((EntityHitResult)p_36913_).getEntity()) || this.level().isClientSide)) {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                areaeffectcloud.setOwner((LivingEntity)entity);
            }
            areaeffectcloud.setParticle((ParticleOptions)TofuParticleTypes.SIMPLE_STINKE.get());
            areaeffectcloud.setRadius(3.0f);
            areaeffectcloud.setDuration(200);
            areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = this.distanceToSqr((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloud.setPos(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                    break;
                }
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    public boolean isPickable() {
        return false;
    }

    protected void defineSynchedData() {
    }

    protected ParticleOptions getTrailParticle() {
        return (ParticleOptions)TofuParticleTypes.SIMPLE_STINKE.get();
    }

    protected boolean shouldBurn() {
        return false;
    }
}

