/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item;

import baguchi.tofucraft.registry.TofuEffects;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DishItem
extends Item {
    private final boolean comfortable;
    private final boolean salt;

    public DishItem(Item.Properties p_41383_) {
        this(p_41383_, true, false);
    }

    public DishItem(Item.Properties p_41383_, boolean comfortable) {
        this(p_41383_, comfortable, false);
    }

    public DishItem(Item.Properties p_41383_, boolean comfortable, boolean salt) {
        super(p_41383_);
        this.comfortable = comfortable;
        this.salt = salt;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        FoodProperties foodProperties;
        ItemStack resultItem = super.finishUsingItem(itemStack, level, livingEntity);
        if (this.comfortable) {
            Optional effect = BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"comfort"));
            FoodProperties foodProperties2 = (FoodProperties)itemStack.get(DataComponents.FOOD);
            if (foodProperties2 != null && effect.isPresent()) {
                livingEntity.addEffect(new MobEffectInstance((Holder)effect.get(), 600 * foodProperties2.nutrition()));
            }
        }
        if (this.salt && (foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD)) != null) {
            livingEntity.addEffect(new MobEffectInstance(TofuEffects.SALT_BOOST, foodProperties.nutrition() * 20 * 60));
        }
        return resultItem;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        Optional effect = BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"comfort"));
        if (effect.isPresent()) {
            p_41423_.add((Component)Component.translatable((String)"tofucraft.has_comfort").withStyle(ChatFormatting.GOLD));
        }
    }
}

