/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NourishmentItem
extends Item {
    public NourishmentItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        FoodProperties foodProperties;
        ItemStack resultItem = super.finishUsingItem(itemStack, level, livingEntity);
        Optional effect = BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"nourishment"));
        if (effect.isPresent() && (foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD)) != null && effect.isPresent()) {
            livingEntity.addEffect(new MobEffectInstance((Holder)effect.get(), 600 * foodProperties.nutrition()));
        }
        return resultItem;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.getValue(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"nourishment"));
        if (effect != null) {
            p_41423_.add((Component)Component.translatable((String)"tofucraft.has_nourishment").withStyle(ChatFormatting.GOLD));
        }
    }
}

