/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item.tool;

import baguchi.tofucraft.block.SuspiciousTofuTerrainBlock;
import baguchi.tofucraft.registry.TofuTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TofuScoopItem
extends Item {
    public TofuScoopItem(Item.Properties group) {
        super(group);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        if (context.getLevel().getBlockState(context.getClickedPos()).is(TofuTags.Blocks.SOFT_TOFU)) {
            ItemStack stack2 = new ItemStack((ItemLike)Item.BY_BLOCK.get(context.getLevel().getBlockState(context.getClickedPos()).getBlock()));
            worldIn.levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)worldIn.getBlockState(context.getClickedPos())));
            worldIn.removeBlock(context.getClickedPos(), false);
            if (!worldIn.isClientSide()) {
                if (context.getPlayer() != null) {
                    stack.hurtAndBreak(1, (LivingEntity)context.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
                double d0 = (double)(worldIn.random.nextFloat() * 0.5f) + 0.25;
                double d1 = worldIn.random.nextFloat() * 0.5f;
                double d2 = (double)(worldIn.random.nextFloat() * 0.5f) + 0.25;
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, stack2);
                itementity.setDefaultPickUpDelay();
                worldIn.addFreshEntity((Entity)itementity);
            }
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41452_) {
        return ItemUseAnimation.BRUSH;
    }

    public int getUseDuration(ItemStack p_272765_) {
        return 200;
    }

    public void onUseTick(Level p_273467_, LivingEntity p_273619_, ItemStack p_273316_, int p_273101_) {
        if (p_273101_ >= 0 && p_273619_ instanceof Player) {
            Player player = (Player)p_273619_;
            HitResult hitresult = this.calculateHitResult(player);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (p_273467_ instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)p_273467_;
                    if (hitresult.getType() == HitResult.Type.BLOCK) {
                        boolean flag;
                        int i = this.getUseDuration(p_273316_) - p_273101_ + 1;
                        boolean bl = flag = i % 10 == 5;
                        if (flag) {
                            SoundEvent soundevent;
                            BlockPos blockpos = blockhitresult.getBlockPos();
                            BlockState blockstate = p_273467_.getBlockState(blockpos);
                            HumanoidArm humanoidarm = p_273619_.getUsedItemHand() == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
                            this.spawnDustParticles(p_273467_, blockhitresult, blockstate, p_273619_.getViewVector(0.0f), humanoidarm);
                            Block $$18 = blockstate.getBlock();
                            if ($$18 instanceof SuspiciousTofuTerrainBlock) {
                                SuspiciousTofuTerrainBlock brushableblock = (SuspiciousTofuTerrainBlock)$$18;
                                soundevent = brushableblock.getBrushSound();
                            } else {
                                soundevent = SoundEvents.BRUSH_GENERIC;
                            }
                            p_273467_.playSound(player, blockpos, soundevent, SoundSource.BLOCKS);
                            if (!p_273467_.isClientSide()) {
                                BrushableBlockEntity brushableblockentity;
                                boolean flag1;
                                BlockEntity blockentity = p_273467_.getBlockEntity(blockpos);
                                if ($$18 instanceof SuspiciousTofuTerrainBlock && blockentity instanceof BrushableBlockEntity && (flag1 = (brushableblockentity = (BrushableBlockEntity)blockentity).brush(p_273467_.getGameTime(), serverLevel, player, blockhitresult.getDirection(), p_273316_))) {
                                    EquipmentSlot equipmentslot = p_273316_.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                                    p_273316_.hurtAndBreak(1, p_273619_, equipmentslot);
                                }
                            }
                        }
                        return;
                    }
                }
            }
            p_273619_.releaseUsingItem();
        } else {
            p_273619_.releaseUsingItem();
        }
    }

    private HitResult calculateHitResult(Player p_305856_) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)p_305856_, p_281111_ -> !p_281111_.isSpectator() && p_281111_.isPickable(), (double)p_305856_.blockInteractionRange());
    }

    public void spawnDustParticles(Level p_278327_, BlockHitResult p_278272_, BlockState p_278235_, Vec3 p_278337_, HumanoidArm p_285071_) {
        double d0 = 3.0;
        int i = p_285071_ == HumanoidArm.RIGHT ? 1 : -1;
        int j = p_278327_.getRandom().nextInt(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.BLOCK, p_278235_);
        Direction direction = p_278272_.getDirection();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(p_278337_, direction);
        Vec3 vec3 = p_278272_.getLocation();
        for (int k = 0; k < j; ++k) {
            p_278327_.addParticle((ParticleOptions)blockparticleoption, vec3.x - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.y, vec3.z - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * p_278327_.getRandom().nextDouble(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * p_278327_.getRandom().nextDouble());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 p_273421_, Direction p_272987_) {
            double d0 = 0.0;
            return switch (p_272987_) {
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(p_273421_.z(), 0.0, -p_273421_.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

