/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.mixin;

import baguchi.tofucraft.registry.TofuFluidTypes;
import baguchi.tofucraft.registry.TofuParticleTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IEntityExtension;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntityExtension {
    @Shadow
    protected boolean firstTick;
    @Unique
    protected boolean tofuCraftReload_Recode$wasTouchingSoyMilk;
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    public float fallDistance;

    @Shadow
    public abstract boolean isAttackable();

    @Shadow
    public abstract DamageSources damageSources();

    @Shadow
    public abstract boolean hurtServer(ServerLevel var1, DamageSource var2, float var3);

    @Shadow
    public abstract double getFluidTypeHeight(FluidType var1);

    @Inject(method={"updateInWaterStateAndDoFluidPushing"}, at={@At(value="RETURN")})
    protected void updateInWaterStateAndDoFluidPushing(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        this.tofuCraftReload_Recode$updateInSoyMilk();
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo ci) {
        ServerLevel serverlevel;
        Level level;
        Entity entity = (Entity)this;
        if (this.tofuCraftReload_Recode$isInDoubanjang() && this.isAttackable() && (level = this.level()) instanceof ServerLevel && this.hurtServer(serverlevel = (ServerLevel)level, this.damageSources().lava(), 2.0f)) {
            this.fallDistance *= this.getFluidFallDistanceModifier(TofuFluidTypes.DOUBANJIANG.get());
        }
    }

    @Unique
    public boolean tofuCraftReload_Recode$isInDoubanjang() {
        return this.getFluidTypeHeight(TofuFluidTypes.DOUBANJIANG.get()) > 0.0;
    }

    @Unique
    void tofuCraftReload_Recode$updateInSoyMilk() {
        if (this.isInFluidType(TofuFluidTypes.SOYMILK.get()) || this.isInFluidType(TofuFluidTypes.SOYMILK_HELL.get()) || this.isInFluidType(TofuFluidTypes.SOYMILK_SOUL.get())) {
            if (!this.tofuCraftReload_Recode$wasTouchingSoyMilk && !this.firstTick) {
                this.tofuCraftReload_Recode$doTofuSplashEffect();
            }
            this.tofuCraftReload_Recode$wasTouchingSoyMilk = true;
        } else {
            this.tofuCraftReload_Recode$wasTouchingSoyMilk = false;
        }
    }

    @Unique
    protected void tofuCraftReload_Recode$doTofuSplashEffect() {
        Entity realEntity = (Entity)this;
        Entity entity = realEntity.isVehicle() && realEntity.getControllingPassenger() != null ? realEntity.getControllingPassenger() : realEntity;
        float f = entity == realEntity ? 0.2f : 0.9f;
        Vec3 vec3 = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3.x * vec3.x * (double)0.2f + vec3.y * vec3.y + vec3.z * vec3.z * (double)0.2f) * f);
        if (f1 < 0.25f) {
            realEntity.playSound(this.getSwimSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            realEntity.playSound(this.getSwimHighSpeedSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float f2 = Mth.floor((double)realEntity.getY());
        int i = 0;
        while ((float)i < 1.0f + this.dimensions.width() * 20.0f) {
            double d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            double d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, realEntity.getX() + d0, (double)(f2 + 1.0f), realEntity.getZ() + d1, vec3.x, vec3.y - this.random.nextDouble() * (double)0.2f, vec3.z);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.dimensions.width() * 20.0f) {
            double d2 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            double d3 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), realEntity.getX() + d2, (double)(f2 + 1.0f), realEntity.getZ() + d3, vec3.x, vec3.y, vec3.z);
            ++j;
        }
        realEntity.gameEvent((Holder)GameEvent.SPLASH);
    }

    @Shadow
    protected SoundEvent getSwimHighSpeedSplashSound() {
        return null;
    }

    @Shadow
    protected SoundEvent getSwimSplashSound() {
        return null;
    }

    @Shadow
    public Level level() {
        return null;
    }
}

