/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.mixin;

import baguchi.tofucraft.block.TofuTerrainBlock;
import baguchi.tofucraft.entity.Zundamite;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuDimensions;
import baguchi.tofucraft.registry.TofuEntityTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends Entity {
    @Shadow
    private int life;

    @Shadow
    protected abstract BlockPos getStrikePosition();

    public LightningBoltMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;powerLightningRod()V", shift=At.Shift.AFTER)})
    public void tick(CallbackInfo callbackInfo) {
        if (this.life == 2) {
            LightningBoltMixin.makeZundaOnLightningStrike(this.level(), this.getStrikePosition());
            this.makeZundamiteOnLightningStrike();
        }
    }

    private void makeZundamiteOnLightningStrike() {
        Zundamite zundamite;
        BlockState blockstate = this.level().getBlockState(this.getStrikePosition());
        if (this.level().dimension() == TofuDimensions.tofu_world && !blockstate.is(Blocks.LIGHTNING_ROD) && this.random.nextInt(2) == 0 && (zundamite = (Zundamite)TofuEntityTypes.ZUNDAMITE.get().create(this.level(), EntitySpawnReason.MOB_SUMMONED)) != null) {
            zundamite.setPos(this.getStrikePosition().above().getCenter());
            zundamite.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 600));
            this.level().addFreshEntity((Entity)zundamite);
        }
    }

    private static void makeZundaOnLightningStrike(Level p_147151_, BlockPos p_147152_) {
        BlockState blockstate1;
        BlockPos blockpos;
        BlockState blockstate = p_147151_.getBlockState(p_147152_);
        if (blockstate.is(Blocks.LIGHTNING_ROD)) {
            blockpos = p_147152_.relative(((Direction)blockstate.getValue((Property)LightningRodBlock.FACING)).getOpposite());
            blockstate1 = p_147151_.getBlockState(blockpos);
        } else {
            blockpos = p_147152_;
            blockstate1 = blockstate;
        }
        if (blockstate1.getBlock() instanceof TofuTerrainBlock) {
            p_147151_.setBlockAndUpdate(blockpos, ((Block)TofuBlocks.TOFU_TERRAIN_ZUNDA.get()).defaultBlockState());
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_147152_.mutable();
            int i = p_147151_.random.nextInt(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = p_147151_.random.nextInt(8) + 1;
                LightningBoltMixin.randomWalkCleaningCopper(p_147151_, blockpos, blockpos$mutableblockpos, k);
            }
        }
    }

    private static void randomWalkCleaningCopper(Level p_147146_, BlockPos p_147147_, BlockPos.MutableBlockPos p_147148_, int p_147149_) {
        Optional<BlockPos> optional;
        p_147148_.set((Vec3i)p_147147_);
        for (int i = 0; i < p_147149_ && !(optional = LightningBoltMixin.randomStepZunda(p_147146_, (BlockPos)p_147148_)).isEmpty(); ++i) {
            p_147148_.set((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> randomStepZunda(Level p_147154_, BlockPos p_147155_) {
        for (BlockPos blockpos : BlockPos.randomInCube((RandomSource)p_147154_.random, (int)10, (BlockPos)p_147155_, (int)1)) {
            BlockState blockstate = p_147154_.getBlockState(blockpos);
            if (!(blockstate.getBlock() instanceof TofuTerrainBlock)) continue;
            if (TofuTerrainBlock.canBeGrass(blockstate, (LevelReader)p_147154_, blockpos)) {
                p_147154_.setBlockAndUpdate(blockpos, ((Block)TofuBlocks.TOFU_TERRAIN_ZUNDA.get()).defaultBlockState());
            }
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }
}

