/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.network;

import baguchi.tofucraft.network.GuiHooks;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class BossInfoPacket
implements CustomPacketPayload {
    protected final UUID bossEvent;
    protected final int entityID;

    public BossInfoPacket(UUID bossEvent, int entityID) {
        this.bossEvent = bossEvent;
        this.entityID = entityID;
    }

    public UUID getBossEvent() {
        return this.bossEvent;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static class Remove
    extends BossInfoPacket {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"remove_custom_bossbar"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BossInfoPacket::getBossEvent, (StreamCodec)ByteBufCodecs.INT, BossInfoPacket::getEntityID, Remove::new);

        public Remove(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public CustomPacketPayload.Type<Remove> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            GuiHooks.BOSS_EVENTS.remove(payload.bossEvent);
        }
    }

    public static class Display
    extends BossInfoPacket {
        public static final CustomPacketPayload.Type<Display> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"add_custom_bossbar"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BossInfoPacket::getBossEvent, (StreamCodec)ByteBufCodecs.INT, BossInfoPacket::getEntityID, Display::new);

        public Display(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public CustomPacketPayload.Type<Display> type() {
            return TYPE;
        }

        public static void execute(Display payload, IPayloadContext context) {
            GuiHooks.BOSS_EVENTS.put(payload.bossEvent, payload.entityID);
        }
    }
}

