/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.recipe;

import baguchi.tofucraft.registry.TofuRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class BitternRecipe
implements Recipe<RecipeInput> {
    protected FluidStack fluid;
    protected Ingredient ingredient;
    final ItemStack result;

    public BitternRecipe(FluidStack fluid, Ingredient ingredient, ItemStack results) {
        this.fluid = fluid;
        this.ingredient = ingredient;
        this.result = results;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public Ingredient getBitternIngredient() {
        return this.ingredient;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        ItemStack stack = recipeInput.getItem(0);
        ItemStack stack2 = recipeInput.getItem(1);
        @Nullable IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null && !stack2.isEmpty()) {
            return fluidHandler.isFluidValid(1000, this.fluid) && this.ingredient.test(stack2);
        }
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.getResult().copy();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return TofuRecipes.RECIPE_BITTERN.get();
    }

    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return TofuRecipes.RECIPETYPE_BITTERN.get();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }
}

