/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.registry;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.entity.FukumameThrower;
import baguchi.tofucraft.entity.ShuDofuSpider;
import baguchi.tofucraft.entity.TofuCow;
import baguchi.tofucraft.entity.TofuCreeper;
import baguchi.tofucraft.entity.TofuFish;
import baguchi.tofucraft.entity.TofuGandlem;
import baguchi.tofucraft.entity.TofuGolem;
import baguchi.tofucraft.entity.TofuPig;
import baguchi.tofucraft.entity.TofuSlime;
import baguchi.tofucraft.entity.TofuSpider;
import baguchi.tofucraft.entity.Tofunian;
import baguchi.tofucraft.entity.TravelerTofunian;
import baguchi.tofucraft.entity.Zundamite;
import baguchi.tofucraft.entity.effect.NattoCobWebEntity;
import baguchi.tofucraft.entity.projectile.FallingTofuEntity;
import baguchi.tofucraft.entity.projectile.FukumameEntity;
import baguchi.tofucraft.entity.projectile.NattoBallEntity;
import baguchi.tofucraft.entity.projectile.NattoStringEntity;
import baguchi.tofucraft.entity.projectile.NetherFukumameEntity;
import baguchi.tofucraft.entity.projectile.SoulFukumameEntity;
import baguchi.tofucraft.entity.projectile.SoyballEntity;
import baguchi.tofucraft.entity.projectile.ZundaArrow;
import baguchi.tofucraft.registry.TofuFluidTypes;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuTags;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="tofucraft", bus=EventBusSubscriber.Bus.MOD)
public class TofuEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"tofucraft");
    public static final Supplier<EntityType<Tofunian>> TOFUNIAN = ENTITIES.register("tofunian", () -> EntityType.Builder.of(Tofunian::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.2f).eyeHeight(0.96000004f).clientTrackingRange(10).passengerAttachments(new float[]{1.2f}).ridingOffset(-0.3f).build(TofuEntityTypes.prefix("tofunian")));
    public static final Supplier<EntityType<TravelerTofunian>> TRAVELER_TOFUNIAN = ENTITIES.register("traveler_tofunian", () -> EntityType.Builder.of(TravelerTofunian::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.2f).eyeHeight(0.96000004f).build(TofuEntityTypes.prefix("traveler_tofunian")));
    public static final Supplier<EntityType<TofuCow>> TOFUCOW = ENTITIES.register("tofu_cow", () -> EntityType.Builder.of(TofuCow::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).eyeHeight(1.12f).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_cow")));
    public static final Supplier<EntityType<TofuPig>> TOFUPIG = ENTITIES.register("tofu_pig", () -> EntityType.Builder.of(TofuPig::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 0.9f).eyeHeight(0.71999997f).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_pig")));
    public static final Supplier<EntityType<TofuFish>> TOFUFISH = ENTITIES.register("tofu_fish", () -> EntityType.Builder.of(TofuFish::new, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.35f).eyeHeight(0.3f).setTrackingRange(4).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_fish")));
    public static final Supplier<EntityType<TofuGolem>> TOFU_GOLEM = ENTITIES.register("tofu_golem", () -> EntityType.Builder.of(TofuGolem::new, (MobCategory)MobCategory.MISC).sized(0.8f, 0.9f).eyeHeight(0.495f).clientTrackingRange(10).fireImmune().build(TofuEntityTypes.prefix("tofu_golem")));
    public static final Supplier<EntityType<TofuGandlem>> TOFU_GANDLEM = ENTITIES.register("tofu_gandlem", () -> EntityType.Builder.of(TofuGandlem::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.6f).eyeHeight(1.2800001f).clientTrackingRange(10).fireImmune().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_gandlem")));
    public static final Supplier<EntityType<TofuSlime>> TOFUSLIME = ENTITIES.register("tofu_slime", () -> EntityType.Builder.of(TofuSlime::new, (MobCategory)MobCategory.MONSTER).sized(0.52f, 0.52f).eyeHeight(0.325f).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_slime")));
    public static final Supplier<EntityType<TofuCreeper>> TOFUCREEPER = ENTITIES.register("tofu_creeper", () -> EntityType.Builder.of(TofuCreeper::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.6f).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_creeper")));
    public static final Supplier<EntityType<TofuSpider>> TOFUSPIDER = ENTITIES.register("tofu_spider", () -> EntityType.Builder.of(TofuSpider::new, (MobCategory)MobCategory.MONSTER).sized(0.95f, 0.55f).eyeHeight(0.3f).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("tofu_spider")));
    public static final Supplier<EntityType<Zundamite>> ZUNDAMITE = ENTITIES.register("zundamite", () -> EntityType.Builder.of(Zundamite::new, (MobCategory)MobCategory.MONSTER).sized(0.4f, 0.3f).eyeHeight(0.13f).clientTrackingRange(8).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).build(TofuEntityTypes.prefix("zundamite")));
    public static final Supplier<EntityType<FukumameEntity>> FUKUMAME = ENTITIES.register("fukumame", () -> EntityType.Builder.of(FukumameEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).updateInterval(30).build(TofuEntityTypes.prefix("fukumame")));
    public static final Supplier<EntityType<NetherFukumameEntity>> NETHER_FUKUMAME = ENTITIES.register("nether_fukumame", () -> EntityType.Builder.of(NetherFukumameEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).updateInterval(30).build(TofuEntityTypes.prefix("nether_fukumame")));
    public static final Supplier<EntityType<SoulFukumameEntity>> SOUL_FUKUMAME = ENTITIES.register("soul_fukumame", () -> EntityType.Builder.of(SoulFukumameEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).updateInterval(30).build(TofuEntityTypes.prefix("soul_fukumame")));
    public static final Supplier<EntityType<SoyballEntity>> SOYBALL = ENTITIES.register("soyball", () -> EntityType.Builder.of(SoyballEntity::new, (MobCategory)MobCategory.MISC).sized(0.3f, 0.3f).updateInterval(30).build(TofuEntityTypes.prefix("soyball")));
    public static final Supplier<EntityType<NattoStringEntity>> NATTO_STRNIG = ENTITIES.register("natto_string", () -> EntityType.Builder.of(NattoStringEntity::new, (MobCategory)MobCategory.MISC).sized(0.2f, 0.2f).updateInterval(40).build(TofuEntityTypes.prefix("natto_string")));
    public static final Supplier<EntityType<ZundaArrow>> ZUNDA_ARROW = ENTITIES.register("zunda_arrow", () -> EntityType.Builder.of(ZundaArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).updateInterval(40).build(TofuEntityTypes.prefix("zunda_arrow")));
    public static final Supplier<EntityType<NattoCobWebEntity>> NATTO_COBWEB = ENTITIES.register("natto_cobweb", () -> EntityType.Builder.of(NattoCobWebEntity::new, (MobCategory)MobCategory.MISC).sized(3.0f, 0.1f).updateInterval(10).fireImmune().build(TofuEntityTypes.prefix("natto_cobweb")));
    public static final Supplier<EntityType<NattoBallEntity>> NATTO_BALL = ENTITIES.register("natto_ball", () -> EntityType.Builder.of(NattoBallEntity::new, (MobCategory)MobCategory.MISC).sized(0.35f, 0.35f).updateInterval(20).build(TofuEntityTypes.prefix("natto_ball")));
    public static final Supplier<EntityType<FallingTofuEntity>> FALLING_TOFU = ENTITIES.register("falling_tofu", () -> EntityType.Builder.of(FallingTofuEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).updateInterval(20).build(TofuEntityTypes.prefix("falling_tofu")));
    public static final Supplier<EntityType<ShuDofuSpider>> SHUDOFUSPIDER = ENTITIES.register("shudofuspider", () -> EntityType.Builder.of(ShuDofuSpider::new, (MobCategory)MobCategory.CREATURE).sized(3.5f, 2.9f).eyeHeight(2.0f).clientTrackingRange(10).requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).fireImmune().build(TofuEntityTypes.prefix("shudofuspider")));
    public static final Supplier<EntityType<FukumameThrower>> FUKUMAME_THROWER = ENTITIES.register("fukumame_thrower", () -> EntityType.Builder.of(FukumameThrower::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).eyeHeight(1.79f).passengerAttachments(new float[]{2.0125f}).ridingOffset(-0.7f).clientTrackingRange(8).build(TofuEntityTypes.prefix("fukumame_thrower")));
    public static final Supplier<EntityType<Boat>> LEEK_BOAT = ENTITIES.register("leek_boat", () -> EntityType.Builder.of(TofuEntityTypes.boatFactory(TofuItems.LEEK_BOAT), (MobCategory)MobCategory.MISC).noLootTable().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(TofuEntityTypes.prefix("leek_boat")));
    public static final Supplier<EntityType<ChestBoat>> LEEK_CHEST_BOAT = ENTITIES.register("leek_chest_boat", () -> EntityType.Builder.of(TofuEntityTypes.chestBoatFactory(TofuItems.LEEK_CHEST_BOAT), (MobCategory)MobCategory.MISC).noLootTable().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(TofuEntityTypes.prefix("leek_chest_boat")));
    public static final Supplier<EntityType<Boat>> LEEK_GREEN_BOAT = ENTITIES.register("leek_green_boat", () -> EntityType.Builder.of(TofuEntityTypes.boatFactory(TofuItems.LEEK_GREEN_BOAT), (MobCategory)MobCategory.MISC).noLootTable().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(TofuEntityTypes.prefix("leek_green_boat")));
    public static final Supplier<EntityType<ChestBoat>> LEEK_GREEN_CHEST_BOAT = ENTITIES.register("leek_green_chest_boat", () -> EntityType.Builder.of(TofuEntityTypes.chestBoatFactory(TofuItems.LEEK_GREEN_CHEST_BOAT), (MobCategory)MobCategory.MISC).noLootTable().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(TofuEntityTypes.prefix("leek_green_chest_boat")));
    public static final Supplier<EntityType<Boat>> TOFU_STEM_BOAT = ENTITIES.register("tofu_stem_boat", () -> EntityType.Builder.of(TofuEntityTypes.boatFactory(TofuItems.TOFU_STEM_BOAT), (MobCategory)MobCategory.MISC).noLootTable().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(TofuEntityTypes.prefix("tofu_stem_boat")));
    public static final Supplier<EntityType<ChestBoat>> TOFU_STEM_CHEST_BOAT = ENTITIES.register("tofu_stem_chest_boat", () -> EntityType.Builder.of(TofuEntityTypes.chestBoatFactory(TofuItems.TOFU_STEM_CHEST_BOAT), (MobCategory)MobCategory.MISC).noLootTable().requiredFeatures(new FeatureFlag[]{TofuCraftReload.EXPERIMENTAL}).sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(TofuEntityTypes.prefix("tofu_stem_chest_boat")));
    public static final SpawnPlacementType IN_DOUBANJIANG = (p_325672_, p_325673_, p_325674_) -> {
        if (p_325674_ != null && p_325672_.getWorldBorder().isWithinBounds(p_325673_)) {
            BlockPos blockpos = p_325673_.above();
            return p_325672_.getFluidState(p_325673_).getType() == TofuFluidTypes.DOUBANJIANG;
        }
        return false;
    };
    public static final SpawnPlacementType IN_SOYMILK = (p_325672_, p_325673_, p_325674_) -> {
        if (p_325674_ != null && p_325672_.getWorldBorder().isWithinBounds(p_325673_)) {
            BlockPos blockpos = p_325673_.above();
            return p_325672_.getFluidState(p_325673_).is(TofuTags.Fluids.SOYMILK) && !p_325672_.getBlockState(blockpos).isRedstoneConductor((BlockGetter)p_325672_, blockpos);
        }
        return false;
    };

    private static EntityType.EntityFactory<Boat> boatFactory(Supplier<Item> p_376580_) {
        return (p_375558_, p_375559_) -> new Boat(p_375558_, p_375559_, p_376580_);
    }

    private static EntityType.EntityFactory<ChestBoat> chestBoatFactory(Supplier<Item> p_376578_) {
        return (p_375555_, p_375556_) -> new ChestBoat(p_375555_, p_375556_, p_376578_);
    }

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put(TOFUCOW.get(), TofuCow.createAttributes().build());
        event.put(TOFUPIG.get(), TofuPig.createAttributes().build());
        event.put(TOFUNIAN.get(), Tofunian.createAttributes().build());
        event.put(TRAVELER_TOFUNIAN.get(), Tofunian.createAttributes().build());
        event.put(TOFUFISH.get(), AbstractFish.createAttributes().build());
        event.put(TOFU_GOLEM.get(), TofuGolem.createAttributes().build());
        event.put(TOFUSLIME.get(), Monster.createMonsterAttributes().build());
        event.put(TOFUCREEPER.get(), TofuCreeper.createAttributes().build());
        event.put(TOFUSPIDER.get(), TofuSpider.createAttributes().build());
        event.put(ZUNDAMITE.get(), Zundamite.createAttributes().build());
        event.put(TOFU_GANDLEM.get(), TofuGandlem.createAttributes().build());
        event.put(SHUDOFUSPIDER.get(), ShuDofuSpider.createAttributes().build());
        event.put(NATTO_COBWEB.get(), NattoCobWebEntity.createAttributes().build());
        event.put(FUKUMAME_THROWER.get(), FukumameThrower.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerEntityAttribute(RegisterSpawnPlacementsEvent event) {
        event.register(TOFUCOW.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuCow::checkTofuAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUPIG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuPig::checkTofuAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUNIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TRAVELER_TOFUNIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFU_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUSLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuSlime::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUCREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUSPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFUFISH.get(), IN_SOYMILK, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TofuFish::checkTofuFishSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(TOFU_GANDLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(FUKUMAME_THROWER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FukumameThrower::checkFukumameSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(ZUNDAMITE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    private static ResourceKey<EntityType<?>> prefix(String path) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)path));
    }
}

