/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.utils.RecipeHelper;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TofuBlock
extends Block {
    public static final IntegerProperty HARDNESS = IntegerProperty.m_61631_((String)"hardness", (int)0, (int)7);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public TofuBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.m_214162_(stateIn, worldIn, pos, rand);
        if (this.isUnderWeight(worldIn, pos)) {
            float f;
            if (rand.m_188503_(5) == 0) {
                double d4 = rand.m_188499_() ? 0.8 : -0.8;
                double d0 = (double)pos.m_123341_() + 0.5 + (double)rand.m_188501_() * d4;
                double d1 = (float)pos.m_123342_() + rand.m_188501_();
                double d2 = (double)pos.m_123343_() + 0.5 + (double)rand.m_188501_() * d4;
                SimpleParticleType particle = rand.m_188503_(3) == 0 ? (ParticleOptions)TofuParticleTypes.DRIP_SOYMILK_HANG.get() : ParticleTypes.f_123803_;
                worldIn.m_7106_((ParticleOptions)particle, d0, d1, d2, 0.0, 0.0, 0.0);
            }
            if (this.isMoreHardenCondition(worldIn, pos) && !((f = rand.m_188501_()) > 0.15f)) {
                TofuBlock.spawnDripParticle(worldIn, pos.m_6625_(2), stateIn);
            }
        }
    }

    private static void spawnDripParticle(Level p_154072_, BlockPos p_154073_, BlockState p_154074_) {
        Vec3 vec3 = p_154074_.m_60824_((BlockGetter)p_154072_, p_154073_);
        double d0 = 0.0625;
        double d1 = (double)p_154073_.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(p_154073_.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)p_154073_.m_123343_() + 0.5 + vec3.f_82481_;
        SimpleParticleType particleoptions = ParticleTypes.f_175824_;
        p_154072_.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.m_213898_(state, worldIn, pos, random);
        if (this.isDriedCondition((Level)worldIn, pos)) {
            if (random.m_188503_(8) == 0 && this == TofuBlocks.MOMENTOFU.get()) {
                worldIn.m_7731_(pos, ((Block)TofuBlocks.DRIEDTOFU.get()).m_49966_(), 2);
            }
        } else if (this.isUnderWeight((Level)worldIn, pos) && state.m_61138_((Property)HARDNESS)) {
            int hardness;
            boolean dripStoneFlag = this.isMoreHardenCondition((Level)worldIn, pos);
            int i = (Integer)state.m_61143_((Property)HARDNESS);
            int hardenSpeed = dripStoneFlag ? 1 : 0;
            int n = hardness = this == TofuBlocks.MOMENTOFU.get() ? 3 - hardenSpeed : 4 - hardenSpeed;
            if (random.m_188503_(hardness) == 0) {
                if (i < 7) {
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HARDNESS, (Comparable)Integer.valueOf(i + 1)), 2);
                } else {
                    ItemStack result = RecipeHelper.getTofu(worldIn, state.m_60734_());
                    if (result != null) {
                        worldIn.m_7731_(pos, Block.m_49814_((Item)result.m_41720_()).m_49966_(), 2);
                    }
                }
            }
        }
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor p_202007_, BlockPos p_202008_, Direction.AxisDirection p_202009_, BiPredicate<BlockPos, BlockState> p_202010_, Predicate<BlockState> p_202011_, int p_202012_) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)p_202009_, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_202008_.m_122032_();
        for (int i = 1; i < p_202012_; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = p_202007_.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (p_202011_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!p_202007_.m_151562_(blockpos$mutableblockpos.m_123342_()) && p_202010_.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level p_154077_, BlockPos p_154078_, Fluid p_154079_) {
        Predicate<BlockState> predicate = p_154162_ -> p_154162_.m_60734_() instanceof CauldronBlock;
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202034_, p_202035_) -> TofuBlock.canDripThrough((BlockGetter)p_154077_, p_202034_, p_202035_);
        return TofuBlock.findBlockVertical((LevelAccessor)p_154077_, p_154078_, Direction.DOWN.m_122421_(), bipredicate, predicate, 11).orElse(null);
    }

    private static boolean canDripThrough(BlockGetter p_202018_, BlockPos p_202019_, BlockState p_202020_) {
        if (p_202020_.m_60795_()) {
            return true;
        }
        if (p_202020_.m_60804_(p_202018_, p_202019_)) {
            return false;
        }
        if (!p_202020_.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = p_202020_.m_60812_(p_202018_, p_202019_);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
    }

    public boolean isMoreHardenCondition(Level world, BlockPos pos) {
        BlockState dripstoneBlock = world.m_8055_(pos.m_6625_(2));
        return dripstoneBlock.m_60713_(Blocks.f_152588_) && dripstoneBlock.m_61143_((Property)PointedDripstoneBlock.f_154009_) == Direction.DOWN;
    }

    public boolean isUnderWeight(Level world, BlockPos pos) {
        BlockState weightBlock = world.m_8055_(pos.m_7494_());
        BlockState baseBlock = world.m_8055_(pos.m_7495_());
        float weightHardness = weightBlock.m_60800_((BlockGetter)world, pos.m_7494_());
        boolean isWeightValid = weightBlock != null && (weightHardness >= 1.0f || weightHardness < 0.0f) && !(weightBlock.m_60734_() instanceof TofuBlock);
        float baseHardness = baseBlock.m_60800_((BlockGetter)world, pos.m_7495_());
        boolean isBaseValid = baseBlock.m_60838_((BlockGetter)world, pos) && (baseHardness >= 1.0f || baseHardness < 0.0f) && !(baseBlock.m_60734_() instanceof TofuBlock);
        return isWeightValid && isBaseValid;
    }

    public boolean isUnderWithConditionBlock(Level world, BlockPos pos, Block block) {
        BlockState weightBlock = world.m_8055_(pos.m_7494_());
        BlockState baseBlock = world.m_8055_(pos.m_7495_());
        boolean isWeightValid = this != weightBlock.m_60734_() && weightBlock != null && weightBlock.m_60734_() == block;
        float baseHardness = baseBlock.m_60800_((BlockGetter)world, pos.m_7495_());
        boolean isBaseValid = baseBlock.m_60838_((BlockGetter)world, pos) && (baseHardness >= 1.0f || baseHardness < 0.0f);
        return isWeightValid && isBaseValid;
    }

    public boolean isDriedCondition(Level world, BlockPos pos) {
        BlockState upperBlock = world.m_8055_(pos.m_6630_(1));
        return ((Biome)world.m_204166_(pos).m_203334_()).m_47554_() < 0.15f && !world.m_45527_(pos.m_7494_()) && upperBlock.m_60795_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.m_61104_(new Property[]{HARDNESS});
    }
}

