/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.registry.TofuBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class TofuFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public TofuFarmlandBlock(BlockBehaviour.Properties p_53247_) {
        super(p_53247_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState p_53276_, Direction p_53277_, BlockState p_53278_, LevelAccessor p_53279_, BlockPos p_53280_, BlockPos p_53281_) {
        if (p_53277_ == Direction.UP && !p_53276_.m_60710_((LevelReader)p_53279_, p_53280_) && !p_53279_.m_183326_().m_183582_(p_53280_, (Object)this)) {
            p_53279_.m_186460_(p_53280_, (Block)this, 1);
        }
        return super.m_7417_(p_53276_, p_53277_, p_53278_, p_53279_, p_53280_, p_53281_);
    }

    public boolean m_7898_(BlockState p_53272_, LevelReader p_53273_, BlockPos p_53274_) {
        BlockState blockstate = p_53273_.m_8055_(p_53274_.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext p_53249_) {
        return !this.m_49966_().m_60710_((LevelReader)p_53249_.m_43725_(), p_53249_.m_8083_()) ? ((Block)TofuBlocks.TOFU_TERRAIN.get()).m_49966_() : super.m_5573_(p_53249_);
    }

    public boolean m_7923_(BlockState p_53295_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState p_53290_, BlockGetter p_53291_, BlockPos p_53292_, CollisionContext p_53293_) {
        return SHAPE;
    }

    public void m_213897_(BlockState p_53262_, ServerLevel p_53263_, BlockPos p_53264_, RandomSource p_53265_) {
        if (!p_53262_.m_60710_((LevelReader)p_53263_, p_53264_)) {
            TofuFarmlandBlock.turnToDirt(p_53262_, (Level)p_53263_, p_53264_);
        }
    }

    public void m_213898_(BlockState p_53285_, ServerLevel p_53286_, BlockPos p_53287_, RandomSource p_53288_) {
        int i = (Integer)p_53285_.m_61143_((Property)MOISTURE);
        if (!TofuFarmlandBlock.isNearWater((LevelReader)p_53286_, p_53287_) && !p_53286_.m_46758_(p_53287_.m_7494_())) {
            if (i > 0) {
                p_53286_.m_7731_(p_53287_, (BlockState)p_53285_.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!TofuFarmlandBlock.isUnderCrops((BlockGetter)p_53286_, p_53287_)) {
                TofuFarmlandBlock.turnToDirt(p_53285_, (Level)p_53286_, p_53287_);
            }
        } else if (i < 7) {
            p_53286_.m_7731_(p_53287_, (BlockState)p_53285_.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level p_153227_, BlockState p_153228_, BlockPos p_153229_, Entity p_153230_, float p_153231_) {
        if (!p_153227_.f_46443_ && ForgeHooks.onFarmlandTrample((Level)p_153227_, (BlockPos)p_153229_, (BlockState)((Block)TofuBlocks.TOFU_TERRAIN.get()).m_49966_(), (float)p_153231_, (Entity)p_153230_)) {
            TofuFarmlandBlock.turnToDirt(p_153228_, p_153227_, p_153229_);
        }
        super.m_142072_(p_153227_, p_153228_, p_153229_, p_153230_, p_153231_);
    }

    public static void turnToDirt(BlockState p_53297_, Level p_53298_, BlockPos p_53299_) {
        p_53298_.m_46597_(p_53299_, TofuFarmlandBlock.m_49897_((BlockState)p_53297_, (BlockState)((Block)TofuBlocks.TOFU_TERRAIN.get()).m_49966_(), (LevelAccessor)p_53298_, (BlockPos)p_53299_));
    }

    private static boolean isUnderCrops(BlockGetter p_53251_, BlockPos p_53252_) {
        BlockState plant = p_53251_.m_8055_(p_53252_.m_7494_());
        BlockState state = p_53251_.m_8055_(p_53252_);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(p_53251_, p_53252_, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader p_53259_, BlockPos p_53260_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_53260_.m_7918_(-4, 0, -4), (BlockPos)p_53260_.m_7918_(4, 1, 4))) {
            if (!p_53259_.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_53259_, (BlockPos)p_53260_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_53283_) {
        p_53283_.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState p_53267_, BlockGetter p_53268_, BlockPos p_53269_, PathComputationType p_53270_) {
        return false;
    }
}

