/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.capability.TofuLivingCapability;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuDimensions;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.world.TofuLevelTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class TofuPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public TofuPortalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_60978_(-1.0f).m_60910_().m_60953_(state -> 10).m_222994_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean trySpawnPortal(LevelAccessor level, BlockPos pos) {
        TofuPortalShape size = this.isPortal(level, pos);
        if (size != null && !this.isPortalSpawnCanceled(level, pos, size)) {
            size.m_77743_();
            return true;
        }
        return false;
    }

    public boolean isPortalSpawnCanceled(LevelAccessor world, BlockPos pos, TofuPortalShape size) {
        return MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.PortalSpawnEvent(world, pos, world.m_8055_(pos), (PortalShape)size));
    }

    @Nullable
    public TofuPortalShape isPortal(LevelAccessor level, BlockPos pos) {
        TofuPortalShape TofuPortalBlock$size = new TofuPortalShape(level, pos, Direction.Axis.X);
        if (TofuPortalBlock$size.m_77698_() && TofuPortalBlock$size.numPortalBlocks == 0) {
            return TofuPortalBlock$size;
        }
        TofuPortalShape TofuPortalBlock$size1 = new TofuPortalShape(level, pos, Direction.Axis.Z);
        return TofuPortalBlock$size1.m_77698_() && TofuPortalBlock$size1.numPortalBlocks == 0 ? TofuPortalBlock$size1 : null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new TofuPortalShape(level, currentPos, direction$axis1).m_77744_() ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                if (!entity.m_9236_().m_5776_() && !pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos.m_7949_();
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    TofuLivingCapability portal = (TofuLivingCapability)player.getCapability(TofuCraftReload.TOFU_LIVING_CAPABILITY).orElse(null);
                    portal.setInPortal(true);
                    int waitTime = portal.getPortalTimer();
                    if (waitTime >= entity.m_6078_()) {
                        this.transportEntity((Entity)player);
                        portal.setPortalTimer(0);
                    }
                } else {
                    this.transportEntity(entity);
                }
            }
        }
    }

    private void transportEntity(Entity entity) {
        ServerLevel destinationLevel;
        ResourceKey<Level> destination;
        MinecraftServer server = entity.m_9236_().m_7654_();
        ResourceKey<Level> resourceKey = destination = entity.m_9236_().m_46472_() == TofuDimensions.tofu_world ? Level.f_46428_ : TofuDimensions.tofu_world;
        if (server != null && (destinationLevel = server.m_129880_(destination)) != null && server.m_7079_() && !entity.m_20159_()) {
            entity.m_9236_().m_46473_().m_6180_("tofu_portal");
            entity.m_20091_();
            entity.changeDimension(destinationLevel, (ITeleporter)new TofuLevelTeleporter(destinationLevel));
            entity.m_9236_().m_46473_().m_7238_();
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + random.m_188500_();
            double z = (double)pos.m_123343_() + random.m_188500_();
            double xSpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            double ySpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            double zSpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            int j = random.m_188503_(2) * 2 - 1;
            if (!level.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !level.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                xSpeed = random.m_188501_() * 2.0f * (float)j;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                zSpeed = random.m_188501_() * 2.0f * (float)j;
            }
            level.m_7106_((ParticleOptions)TofuParticleTypes.TOFU_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    default -> state;
                };
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public static class TofuPortalShape
    extends PortalShape {
        private static final int MIN_WIDTH = 1;
        public static final int MAX_WIDTH = 21;
        private static final int MIN_HEIGHT = 2;
        public static final int MAX_HEIGHT = 21;
        private static final BlockBehaviour.StatePredicate FRAME = (state, getter, pos) -> state.m_60713_((Block)TofuBlocks.GRILLEDTOFU.get());
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int numPortalBlocks;
        private BlockPos bottomLeft;
        private int height;
        private final int width;

        public TofuPortalShape(LevelAccessor level, BlockPos bottomLeftPos, Direction.Axis axis) {
            super(level, bottomLeftPos, axis);
            this.level = level;
            this.axis = axis;
            this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.m_77733_(bottomLeftPos);
            if (this.bottomLeft == null) {
                this.bottomLeft = bottomLeftPos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.m_77745_();
                if (this.width > 0) {
                    this.height = this.m_77746_();
                }
            }
        }

        @Nullable
        private BlockPos m_77733_(BlockPos pos) {
            int i = Math.max(this.level.m_141937_(), pos.m_123342_() - 21);
            while (pos.m_123342_() > i && TofuPortalShape.m_77717_(this.level.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            Direction direction = this.rightDir.m_122424_();
            int j = this.m_77735_(pos, direction) - 1;
            return j < 0 ? null : pos.m_5484_(direction, j);
        }

        private int m_77745_() {
            int i = this.m_77735_(this.bottomLeft, this.rightDir);
            return i >= 1 && i <= 21 ? i : 0;
        }

        private int m_77735_(BlockPos pos, Direction direction) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i = 0; i <= 21; ++i) {
                mutablePos.m_122190_((Vec3i)pos).m_122175_(direction, i);
                BlockState blockstate = this.level.m_8055_((BlockPos)mutablePos);
                if (!TofuPortalShape.m_77717_(blockstate)) {
                    if (!FRAME.m_61035_(blockstate, (BlockGetter)this.level, (BlockPos)mutablePos)) break;
                    return i;
                }
                BlockState blockstate1 = this.level.m_8055_((BlockPos)mutablePos.m_122173_(Direction.DOWN));
                if (!FRAME.m_61035_(blockstate1, (BlockGetter)this.level, (BlockPos)mutablePos)) break;
            }
            return 0;
        }

        private int m_77746_() {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int i = this.m_77728_(mutablePos);
            return i >= 2 && i <= 21 && this.m_77730_(mutablePos, i) ? i : 0;
        }

        private boolean m_77730_(BlockPos.MutableBlockPos pos, int height) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos mutablePos = pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, height).m_122175_(this.rightDir, i);
                if (FRAME.m_61035_(this.level.m_8055_((BlockPos)mutablePos), (BlockGetter)this.level, (BlockPos)mutablePos)) continue;
                return false;
            }
            return true;
        }

        private int m_77728_(BlockPos.MutableBlockPos pos) {
            for (int i = 0; i < 21; ++i) {
                pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
                if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)pos), (BlockGetter)this.level, (BlockPos)pos)) {
                    return i;
                }
                pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
                if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)pos), (BlockGetter)this.level, (BlockPos)pos)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                    BlockState blockstate = this.level.m_8055_((BlockPos)pos);
                    if (!TofuPortalShape.m_77717_(blockstate)) {
                        return i;
                    }
                    if (!blockstate.m_60713_((Block)TofuBlocks.TOFU_PORTAL.get())) continue;
                    ++this.numPortalBlocks;
                }
            }
            return 21;
        }

        private static boolean m_77717_(BlockState state) {
            return state.m_60795_() || state.m_60713_((Block)TofuBlocks.TOFU_PORTAL.get());
        }

        public boolean m_77698_() {
            return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 2 && this.height <= 21;
        }

        public void m_77743_() {
            BlockState blockstate = (BlockState)((TofuPortalBlock)((Object)TofuBlocks.TOFU_PORTAL.get())).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.axis);
            BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(pos -> this.level.m_7731_(pos, blockstate, 18));
        }

        public boolean m_77744_() {
            return this.m_77698_() && this.numPortalBlocks == this.width * this.height;
        }
    }
}

