/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.blockentity.TofuPotBlockEntity;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class TofuPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public TofuPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        ItemStack stack;
        IFluidHandlerItem handler;
        boolean flag = false;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof TofuPotBlockEntity && (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)(stack = player.m_21120_(hand)).m_255036_(1)).orElse(null)) instanceof FluidBucketWrapper) {
            FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, null);
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_) {
            if (tileEntity instanceof TofuPotBlockEntity) {
                TofuPotBlockEntity cookingPotEntity = (TofuPotBlockEntity)tileEntity;
                player.m_5893_((MenuProvider)cookingPotEntity);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_) {
            TofuCraftReload.PROXY.setRefrencedTE(level.m_7702_(pos));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluid = level.m_6425_(context.m_8083_());
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.m_7397_(level, pos, state);
        Optional cookingPot = level.m_141902_(pos, TofuBlockEntitys.TOFU_POT.get());
        if (cookingPot.isPresent()) {
            stack = ((TofuPotBlockEntity)((Object)cookingPot.get())).getAsItem();
        }
        return stack;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof TofuPotBlockEntity) {
                TofuPotBlockEntity cookingPotEntity = (TofuPotBlockEntity)tileEntity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Containers.m_19010_((Level)level, (BlockPos)pos, cookingPotEntity.inventory);
                    cookingPotEntity.getRecipesToAwardAndPopExperience(serverLevel, Vec3.m_82512_((Vec3i)pos));
                    level.m_46717_(pos, (Block)this);
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        TofuPotBlockEntity cookingPotEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof TofuPotBlockEntity && (cookingPotEntity = (TofuPotBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = !cookingPotEntity.m_8020_(12).m_41619_() ? SoundEvents.f_12032_ : SoundEvents.f_11773_;
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return TofuBlockEntitys.TOFU_POT.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.f_46443_) {
            return TofuPotBlock.m_152132_(blockEntity, TofuBlockEntitys.TOFU_POT.get(), TofuPotBlockEntity::animationTick);
        }
        return TofuPotBlock.m_152132_(blockEntity, TofuBlockEntitys.TOFU_POT.get(), TofuPotBlockEntity::cookingTick);
    }
}

