/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class WeightBaseBlock
extends Block {
    public static final EnumProperty<Stat> STAT = EnumProperty.m_61587_((String)"stat", Stat.class);
    public static final IntegerProperty TIME = IntegerProperty.m_61631_((String)"time", (int)0, (int)5);

    public WeightBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(STAT, (Comparable)((Object)Stat.USING))).m_61124_((Property)TIME, (Comparable)Integer.valueOf(0)));
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        Stat stat = this.getStat(state);
        int time = (Integer)state.m_61143_((Property)TIME);
        if (this.isUnderWeight((Level)worldIn, pos)) {
            if (time < 5 && random.m_188503_(4) == 0) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TIME, (Comparable)Integer.valueOf(time + 1)), 3);
            }
            if (time >= 5 && stat == Stat.USING) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.USED)), 3);
            }
        }
    }

    public boolean isUnderWeight(Level world, BlockPos pos) {
        BlockState weightBlock = world.m_8055_(pos.m_7494_());
        float weightHardness = weightBlock.m_60800_((BlockGetter)world, pos.m_7494_());
        boolean isWeightValid = weightBlock != null && (weightHardness >= 1.0f || weightHardness < 0.0f) && !(weightBlock.m_60734_() instanceof WeightBaseBlock);
        return isWeightValid;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAT, TIME});
    }

    public Stat getStat(BlockState meta) {
        if (meta.m_60734_() == this) {
            return (Stat)((Object)meta.m_61143_(STAT));
        }
        return Stat.USING;
    }

    public static enum Stat implements StringRepresentable
    {
        USING("using"),
        USED("used");

        private final String name;

        private Stat(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

