/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.block.utils.SaltFurnaceBlock;
import baguchan.tofucraft.inventory.SaltFurnaceMenu;
import baguchan.tofucraft.message.SaltFurnaceBitternMessage;
import baguchan.tofucraft.message.SaltFurnaceWaterMessage;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import baguchan.tofucraft.registry.TofuFluids;
import baguchan.tofucraft.registry.TofuItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class SaltFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_SIDES = new int[]{0};
    private static final int[] SLOTS_FOR_UP = new int[]{2, 4};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1, 3, 4};
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    public FluidTank waterTank = new FluidTank(3000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == Fluids.f_76193_;
        }
    };
    public FluidTank bitternTank = new FluidTank(2000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == TofuFluids.BITTERN.get();
        }
    };
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private int prevWaterFluid;
    private int prevBitternFluid;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return SaltFurnaceBlockEntity.this.litTime;
                }
                case 1: {
                    return SaltFurnaceBlockEntity.this.litDuration;
                }
                case 2: {
                    return SaltFurnaceBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return SaltFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    SaltFurnaceBlockEntity.this.litTime = p_221477_2_;
                    break;
                }
                case 1: {
                    SaltFurnaceBlockEntity.this.litDuration = p_221477_2_;
                    break;
                }
                case 2: {
                    SaltFurnaceBlockEntity.this.cookingProgress = p_221477_2_;
                    break;
                }
                case 3: {
                    SaltFurnaceBlockEntity.this.cookingTotalTime = p_221477_2_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.waterTank);
    private final LazyOptional<IFluidHandler> holder2 = LazyOptional.of(() -> this.bitternTank);

    public SaltFurnaceBlockEntity(BlockPos p_155545_, BlockState p_155546_) {
        super((BlockEntityType)TofuBlockEntitys.SALT_FURNACE.get(), p_155545_, p_155546_);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        CompoundTag nbt;
        super.m_142466_(p_230337_2_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (p_230337_2_.m_128425_("WaterTank", 10)) {
            nbt = p_230337_2_.m_128469_("WaterTank");
            this.waterTank = this.waterTank.readFromNBT(nbt);
        }
        if (p_230337_2_.m_128425_("BitternTank", 10)) {
            nbt = p_230337_2_.m_128469_("BitternTank");
            this.bitternTank = this.bitternTank.readFromNBT(nbt);
        }
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.items);
        this.litTime = p_230337_2_.m_128451_("BurnTime");
        this.cookingProgress = p_230337_2_.m_128451_("CookTime");
        this.cookingTotalTime = p_230337_2_.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
    }

    public void m_183515_(CompoundTag p_189515_1_) {
        super.m_183515_(p_189515_1_);
        CompoundTag nbt = new CompoundTag();
        CompoundTag nbt2 = new CompoundTag();
        this.waterTank.writeToNBT(nbt);
        this.bitternTank.writeToNBT(nbt2);
        p_189515_1_.m_128365_("WaterTank", (Tag)nbt);
        p_189515_1_.m_128365_("BitternTank", (Tag)nbt2);
        p_189515_1_.m_128405_("BurnTime", this.litTime);
        p_189515_1_.m_128405_("CookTime", this.cookingProgress);
        p_189515_1_.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.items);
    }

    public static void tick(Level p_155014_, BlockPos p_155015_, BlockState p_155016_, SaltFurnaceBlockEntity saltFurnaceBlock) {
        boolean flag = saltFurnaceBlock.isLit();
        boolean flag1 = false;
        if (saltFurnaceBlock.isLit()) {
            --saltFurnaceBlock.litTime;
        }
        if (!p_155014_.f_46443_) {
            LevelChunk chunk;
            if (saltFurnaceBlock.prevWaterFluid != saltFurnaceBlock.waterTank.getFluidAmount()) {
                chunk = p_155014_.m_46745_(p_155015_);
                TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SaltFurnaceWaterMessage(p_155015_, saltFurnaceBlock.waterTank.getFluid()));
                saltFurnaceBlock.prevWaterFluid = saltFurnaceBlock.waterTank.getFluidAmount();
            }
            if (saltFurnaceBlock.prevBitternFluid != saltFurnaceBlock.bitternTank.getFluidAmount()) {
                chunk = p_155014_.m_46745_(p_155015_);
                TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SaltFurnaceBitternMessage(p_155015_, saltFurnaceBlock.bitternTank.getFluid()));
                saltFurnaceBlock.prevBitternFluid = saltFurnaceBlock.bitternTank.getFluidAmount();
            }
        }
        ItemStack itemstack = (ItemStack)saltFurnaceBlock.items.get(0);
        if (saltFurnaceBlock.isLit() || !((ItemStack)saltFurnaceBlock.items.get(0)).m_41619_()) {
            if (!saltFurnaceBlock.isLit() && saltFurnaceBlock.hasWater()) {
                saltFurnaceBlock.litDuration = saltFurnaceBlock.litTime = saltFurnaceBlock.getBurnDuration(itemstack);
                if (saltFurnaceBlock.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        saltFurnaceBlock.items.set(0, (Object)itemstack.getCraftingRemainingItem());
                    } else if (!itemstack.m_41619_()) {
                        Item item = itemstack.m_41720_();
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            saltFurnaceBlock.items.set(0, (Object)ItemStack.f_41583_);
                        }
                    }
                }
            }
            if (saltFurnaceBlock.isLit() && saltFurnaceBlock.hasWater()) {
                ++saltFurnaceBlock.cookingProgress;
                if (saltFurnaceBlock.cookingProgress == saltFurnaceBlock.cookingTotalTime) {
                    saltFurnaceBlock.cookingProgress = 0;
                    saltFurnaceBlock.cookingTotalTime = saltFurnaceBlock.getTotalCookTime();
                    saltFurnaceBlock.makeSalt();
                    flag1 = true;
                }
            } else {
                saltFurnaceBlock.cookingProgress = 0;
            }
        } else if (!saltFurnaceBlock.isLit() && saltFurnaceBlock.cookingProgress > 0) {
            saltFurnaceBlock.cookingProgress = Mth.m_14045_((int)(saltFurnaceBlock.cookingProgress - 2), (int)0, (int)saltFurnaceBlock.cookingTotalTime);
        }
        if (flag != saltFurnaceBlock.isLit()) {
            flag1 = true;
            saltFurnaceBlock.f_58857_.m_7731_(p_155015_, (BlockState)saltFurnaceBlock.f_58857_.m_8055_(p_155015_).m_61124_((Property)SaltFurnaceBlock.LIT, (Comparable)Boolean.valueOf(saltFurnaceBlock.isLit())), 3);
        }
        saltFurnaceBlock.makeBittern();
        saltFurnaceBlock.putWater();
        if (flag1) {
            saltFurnaceBlock.m_6596_();
        }
    }

    public void m_5856_(Player p_18955_) {
        super.m_5856_(p_18955_);
        if (!this.f_58857_.m_5776_()) {
            LevelChunk chunk = this.f_58857_.m_46745_(this.m_58899_());
            TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SaltFurnaceWaterMessage(this.m_58899_(), this.waterTank.getFluid()));
            TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SaltFurnaceBitternMessage(this.m_58899_(), this.bitternTank.getFluid()));
        }
    }

    protected boolean hasWater() {
        boolean flag = this.waterTank.getFluid().getFluid() == Fluids.f_76193_ && this.waterTank.getFluid().getAmount() >= 200;
        ItemStack itemstack1 = (ItemStack)this.items.get(1);
        if (itemstack1.m_41619_()) {
            return flag;
        }
        if (itemstack1.m_41613_() + 2 <= this.m_6893_() && itemstack1.m_41613_() + 2 <= itemstack1.m_41741_()) {
            return flag;
        }
        return false;
    }

    protected boolean hasBittern() {
        boolean flag = this.bitternTank.getFluid().getFluid() == TofuFluids.BITTERN.get() && this.bitternTank.getFluid().getAmount() >= 200;
        ItemStack itemstack1 = (ItemStack)this.items.get(3);
        ItemStack itemstack2 = (ItemStack)this.items.get(2);
        if (itemstack2.m_41720_() == Items.f_42590_) {
            if (itemstack1.m_41619_()) {
                return flag;
            }
            if (itemstack1.m_41613_() + 1 <= this.m_6893_() && itemstack1.m_41613_() + 1 <= itemstack1.m_41741_()) {
                return flag;
            }
            return false;
        }
        return false;
    }

    protected boolean canPutWater() {
        boolean flag = this.waterTank.getFluid().getAmount() <= 1000;
        ItemStack itemstack1 = (ItemStack)this.items.get(4);
        if (itemstack1.m_41720_() == Items.f_42447_) {
            return flag;
        }
        return false;
    }

    private void putWater() {
        if (this.canPutWater()) {
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42446_, 1);
            ItemStack itemstack2 = (ItemStack)this.items.get(4);
            itemstack2.m_41774_(1);
            if (itemstack2.m_41619_()) {
                this.items.set(4, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            this.waterTank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void makeBittern() {
        if (this.hasBittern()) {
            ItemStack itemstack1 = new ItemStack((ItemLike)TofuItems.BITTERN_BOTTLE.get(), 1);
            ItemStack itemstack2 = (ItemStack)this.items.get(3);
            ItemStack itemstack3 = (ItemStack)this.items.get(2);
            itemstack3.m_41774_(1);
            if (itemstack2.m_41619_()) {
                this.items.set(3, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            this.bitternTank.drain(200, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void makeSalt() {
        if (this.hasWater()) {
            ItemStack itemstack1 = new ItemStack((ItemLike)TofuItems.SALT.get(), 2);
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.m_41619_()) {
                this.items.set(1, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            this.waterTank.drain(200, IFluidHandler.FluidAction.EXECUTE);
            this.bitternTank.fill(new FluidStack((Fluid)TofuFluids.BITTERN.get(), 200), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void popExperience(ServerPlayer p_155004_, ItemStack p_39558_) {
        SaltFurnaceBlockEntity.createExperience(p_155004_.m_284548_(), p_155004_.m_20182_(), 1, p_39558_.m_41613_());
    }

    private static void createExperience(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)p_154999_, (Vec3)p_155000_, (int)i);
    }

    protected int getBurnDuration(ItemStack p_213997_1_) {
        if (p_213997_1_.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)p_213997_1_, (RecipeType)RecipeType.f_44108_);
    }

    protected int getTotalCookTime() {
        return 200;
    }

    public static boolean isFuel(ItemStack p_213991_0_) {
        return ForgeHooks.getBurnTime((ItemStack)p_213991_0_, null) > 0;
    }

    public int[] m_7071_(Direction p_180463_1_) {
        if (p_180463_1_ == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        if (p_180463_1_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return this.m_7013_(p_180462_1_, p_180462_2_);
    }

    public boolean m_7013_(int p_94041_1_, ItemStack p_94041_2_) {
        if (p_94041_1_ == 3 || p_94041_1_ == 1) {
            return false;
        }
        if (p_94041_1_ == 2) {
            return p_94041_2_.m_41720_() == Items.f_42590_;
        }
        if (p_94041_1_ == 4) {
            return p_94041_2_.m_41720_() == Items.f_42447_;
        }
        ItemStack itemstack = (ItemStack)this.items.get(0);
        return SaltFurnaceBlockEntity.isFuel(p_94041_2_) || p_94041_2_.m_41720_() == Items.f_42446_ && itemstack.m_41720_() != Items.f_42446_;
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        if (p_180461_1_ == 0 || p_180461_1_ == 2) {
            return false;
        }
        if (p_180461_1_ == 4) {
            return p_180461_2_.m_41720_() == Items.f_42446_;
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_70301_1_) {
        return (ItemStack)this.items.get(p_70301_1_);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.m_18969_(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack m_8016_(int p_70304_1_) {
        return ContainerHelper.m_18966_(this.items, (int)p_70304_1_);
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        ItemStack itemstack = (ItemStack)this.items.get(p_70299_1_);
        boolean flag = !p_70299_2_.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)p_70299_2_);
        this.items.set(p_70299_1_, (Object)p_70299_2_);
        if (p_70299_2_.m_41613_() > this.m_6893_()) {
            p_70299_2_.m_41764_(this.m_6893_());
        }
        if (p_70299_1_ == 0 && !flag && this.cookingTotalTime == 0) {
            this.cookingTotalTime = this.getTotalCookTime();
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.tofucraft.salt_furnace");
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return new SaltFurnaceMenu(p_58627_, p_58628_, (Container)this, this.dataAccess);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (facing == Direction.UP) {
                return this.holder.cast();
            }
            if (facing != null) {
                return this.holder2.cast();
            }
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
        this.holder.invalidate();
        this.holder2.invalidate();
    }

    public void m_5809_(StackedContents p_40281_) {
        for (ItemStack itemstack : this.items) {
            p_40281_.m_36491_(itemstack);
        }
    }
}

