/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity.tfenergy;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.api.tfenergy.IEnergyExtractable;
import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchan.tofucraft.api.tfenergy.TofuEnergyMap;
import baguchan.tofucraft.block.tfenergy.TFStorageBlock;
import baguchan.tofucraft.blockentity.tfenergy.base.SenderBaseBlockEntity;
import baguchan.tofucraft.inventory.TFStorageMenu;
import baguchan.tofucraft.message.TFStorageSoymilkMessage;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TFStorageBlockEntity
extends SenderBaseBlockEntity
implements WorldlyContainer,
StackedContentsCompatible,
Container,
MenuProvider {
    private static final int POWER = 20;
    private FluidTank tank = new TFStorageTank(2000);
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private int workload = 0;
    private int current_workload = 0;
    private int prevFluid;
    private final LazyOptional<IFluidHandler> holder;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return TFStorageBlockEntity.this.workload;
                }
                case 1: {
                    return TFStorageBlockEntity.this.current_workload;
                }
                case 2: {
                    return TFStorageBlockEntity.this.energy;
                }
                case 3: {
                    return TFStorageBlockEntity.this.energyMax;
                }
            }
            return 0;
        }

        public void m_8050_(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    TFStorageBlockEntity.this.workload = p_221477_2_;
                    break;
                }
                case 1: {
                    TFStorageBlockEntity.this.current_workload = p_221477_2_;
                    break;
                }
                case 2: {
                    TFStorageBlockEntity.this.energy = p_221477_2_;
                    break;
                }
                case 3: {
                    TFStorageBlockEntity.this.energyMax = p_221477_2_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public TFStorageBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TofuBlockEntitys.TF_STORAGE.get(), p_155229_, p_155230_, 5000);
        this.holder = LazyOptional.of(() -> this.tank);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TFStorageBlockEntity tfStorageBlockEntity) {
        if (level.m_5776_()) {
            return;
        }
        SenderBaseBlockEntity.senderUpdate(tfStorageBlockEntity);
        boolean worked = false;
        if (tfStorageBlockEntity.workload > 0 && tfStorageBlockEntity.getEnergyStored() < tfStorageBlockEntity.getMaxEnergyStored()) {
            tfStorageBlockEntity.workload -= tfStorageBlockEntity.receive(Math.min(tfStorageBlockEntity.workload, 20), false);
            worked = true;
        }
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)TFStorageBlock.LIT, (Comparable)Boolean.valueOf(worked)), 3);
        ItemStack from = (ItemStack)tfStorageBlockEntity.inventory.get(0);
        Item item = from.m_41720_();
        if (item instanceof IEnergyInsertable) {
            IEnergyInsertable symbol = (IEnergyInsertable)item;
            if (tfStorageBlockEntity.getEnergyStored() >= 100) {
                tfStorageBlockEntity.drain(symbol.fill(from, 20, false), false);
            }
        }
        ItemStack to = (ItemStack)tfStorageBlockEntity.inventory.get(1);
        if (tfStorageBlockEntity.workload == 0) {
            Map.Entry<FluidStack, Integer> recipe;
            FluidStack milk = tfStorageBlockEntity.getTank().getFluid();
            Item item2 = to.m_41720_();
            if (item2 instanceof IEnergyExtractable) {
                IEnergyExtractable symbol = (IEnergyExtractable)item2;
                tfStorageBlockEntity.workload += symbol.drain(to, 400, false);
            } else if (TofuEnergyMap.getFuel(to) != -1) {
                tfStorageBlockEntity.workload += TofuEnergyMap.getFuel(to);
                to.m_41774_(1);
            }
            if (!milk.isEmpty() && (recipe = TofuEnergyMap.getLiquidFuel(milk)) != null) {
                tfStorageBlockEntity.tank.drain(recipe.getValue().intValue(), IFluidHandler.FluidAction.EXECUTE);
                tfStorageBlockEntity.workload += recipe.getValue().intValue();
            }
            tfStorageBlockEntity.current_workload = tfStorageBlockEntity.workload;
        }
        if (tfStorageBlockEntity.prevFluid != tfStorageBlockEntity.tank.getFluidAmount()) {
            LevelChunk chunk = level.m_46745_(blockPos);
            TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new TFStorageSoymilkMessage(blockPos, tfStorageBlockEntity.tank.getFluid()));
            tfStorageBlockEntity.prevFluid = tfStorageBlockEntity.tank.getFluidAmount();
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    protected void refresh() {
        if (!this.m_58904_().m_5776_()) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().markAndNotifyBlock(this.m_58899_(), this.m_58904_().m_46745_(this.m_58899_()), state, state, 11, 512);
        }
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.m_18969_(this.inventory, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack m_8016_(int p_70304_1_) {
        return ContainerHelper.m_18966_(this.inventory, (int)p_70304_1_);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player p_18946_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_18946_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int par1) {
        return this.current_workload == 0 ? 0 : (this.current_workload - this.workload) * par1 / this.current_workload;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @javax.annotation.Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        ContainerHelper.m_18973_((CompoundTag)cmp, this.inventory);
        cmp.m_128405_("workload", this.workload);
        cmp.m_128405_("current", this.current_workload);
        CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
        cmp.m_128365_("Tank", (Tag)tankTag);
    }

    @Override
    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        ContainerHelper.m_18980_((CompoundTag)cmp, this.inventory);
        this.workload = cmp.m_128451_("workload");
        this.current_workload = cmp.m_128451_("current");
        this.tank = this.tank.readFromNBT(cmp.m_128469_("Tank"));
    }

    public int[] m_7071_(Direction p_19238_) {
        return new int[0];
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, @Nullable Direction p_19237_) {
        return true;
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public int m_6893_() {
        return super.m_6893_();
    }

    public void m_5809_(StackedContents p_40281_) {
        for (ItemStack itemstack : this.inventory) {
            p_40281_.m_36491_(itemstack);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.tofucraft.tf_storage");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new TFStorageMenu(p_39954_, p_39955_, this, this.dataAccess);
    }

    private class TFStorageTank
    extends FluidTank {
        TFStorageTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            TFStorageBlockEntity.this.refresh();
        }
    }
}

