/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity.tfenergy.base;

import baguchan.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.tofucraft.api.tfenergy.TofuNetwork;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnergyBaseBlockEntity
extends BlockEntity
implements ITofuEnergy {
    public static final String TAG_ENERGY = "tf_energy";
    public static final String TAG_ENERGY_MAX = "tf_energy_max";
    public static final String TAG_UUID = "tf_uuid";
    protected String uuid = "";
    protected int energy;
    protected int energyMax;

    public EnergyBaseBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_, int energyMax) {
        super(p_155228_, p_155229_, p_155230_);
        this.energyMax = energyMax;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyMax;
    }

    @Override
    public int receive(int toReceive, boolean simulate) {
        if (this.getEnergyStored() > this.getMaxEnergyStored()) {
            return 0;
        }
        int calculated = Math.min(toReceive, this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += calculated;
        }
        return calculated;
    }

    @Override
    public int drain(int toDrain, boolean simulate) {
        int calculated = Math.min(toDrain, this.getEnergyStored());
        if (!simulate) {
            this.energy -= calculated;
        }
        return calculated;
    }

    @Override
    public boolean canReceive(BlockEntity from) {
        if (!(from instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("It must be a instance of ITofuEnergy!");
        }
        return true;
    }

    @Override
    public boolean canDrain(BlockEntity to) {
        if (!(to instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("It must be a instance of ITofuEnergy!");
        }
        return true;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_(TAG_ENERGY, this.energy);
        compound.m_128359_(TAG_UUID, this.uuid);
        compound.m_128405_(TAG_ENERGY_MAX, this.energyMax);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.energyMax = compound.m_128451_(TAG_ENERGY_MAX);
        this.energy = compound.m_128451_(TAG_ENERGY);
        this.uuid = compound.m_128461_(TAG_UUID);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.m_58904_().m_5776_()) {
            if (this.uuid.isEmpty()) {
                this.uuid = UUID.randomUUID().toString();
            }
            TofuNetwork.Instance.register(this.uuid, this, false);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (!this.m_58904_().m_5776_()) {
            TofuNetwork.Instance.unload(this.uuid, false);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void inventoryChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

