/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.capability;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.message.SoyMilkDrinkedMessage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class SoyHealthCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    private int soyHealthLevel;
    private int soyHealthBaseLevel;
    private long lastTick = -12000L;
    private long lastChangedTick = -12000L;

    public void setSoyHealthLevel(LivingEntity entity, int level, boolean canUpdate) {
        if (canUpdate) {
            this.lastTick = entity.m_9236_().m_46467_();
            this.lastChangedTick = entity.m_9236_().m_46467_();
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237110_((String)"item.tofucraft.soymilk.drink_day", (Object[])new Object[]{level}), true);
            }
        }
        if (!entity.m_9236_().m_5776_()) {
            SoyMilkDrinkedMessage message = new SoyMilkDrinkedMessage(entity, level, canUpdate);
            TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.soyHealthLevel = Mth.m_14045_((int)level, (int)0, (int)20);
    }

    public void setSoyHealthBaseLevel(int level) {
        this.soyHealthBaseLevel = Mth.m_14045_((int)level, (int)0, (int)100);
    }

    public void removeAllSoyHealth(LivingEntity entity) {
        this.soyHealthLevel = 0;
        if (!entity.m_9236_().m_5776_()) {
            SoyMilkDrinkedMessage message = new SoyMilkDrinkedMessage(entity, this.soyHealthLevel, true);
            TofuCraftReload.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public long getRemainTick() {
        return this.lastTick;
    }

    public int getSoyHealthLevel() {
        return this.soyHealthLevel;
    }

    public int getSoyHealthBaseLevel() {
        return this.soyHealthBaseLevel;
    }

    public void tick(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_9236_().m_46467_() > this.lastChangedTick + 24000L && this.soyHealthLevel > 0) {
            this.setSoyHealthLevel(livingEntity, this.soyHealthLevel - 2, false);
            this.lastChangedTick = livingEntity.m_9236_().m_46467_();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == TofuCraftReload.SOY_HEALTH_CAPABILITY ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("RemainTick", this.lastTick);
        nbt.m_128356_("RemainChangedTick", this.lastChangedTick);
        nbt.m_128405_("SoyHealthLevel", this.soyHealthLevel);
        nbt.m_128405_("SoyHealthBaseLevel", this.soyHealthBaseLevel);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.lastTick = nbt.m_128454_("RemainTick");
        this.lastChangedTick = nbt.m_128454_("RemainChangedTick");
        this.soyHealthLevel = nbt.m_128451_("SoyHealthLevel");
        this.soyHealthBaseLevel = nbt.m_128451_("SoyHealthBaseLevel");
    }
}

