/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client;

import baguchan.tofucraft.recipe.TFCraftingCategory;
import baguchan.tofucraft.recipe.TFCraftingRecipe;
import baguchan.tofucraft.recipe.TofuPotCategory;
import baguchan.tofucraft.recipe.TofuPotRecipe;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuRecipeBookTypes;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tofucraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TofuRecipeCategories {
    public static final Supplier<RecipeBookCategories> WORK_STATION_SEARCH = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFU_WORKSTATION_SEARCH", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42522_)}));
    public static final Supplier<RecipeBookCategories> WORK_STATION_TF_MECH = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFU_WORKSTATION_TF_MECH", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.REFLECT_TOFU_SHIELD.get())}));
    public static Supplier<RecipeBookCategories> COOKING_SEARCH = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_COOKING_SEARCH", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42522_)}));
    public static Supplier<RecipeBookCategories> COOKING_MEALS = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_COOKING_MEALS", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.MISOSOUP.get())}));
    public static Supplier<RecipeBookCategories> COOKING_DRINKS = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_COOKING_DRINKS", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.SOYMILK.get())}));
    public static Supplier<RecipeBookCategories> COOKING_MISC = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_COOKING_MISC", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.SOY_CHEESE.get())}));
    public static Supplier<RecipeBookCategories> COOKING_FAST_FOOD = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_COOKING_FAST_FOODS", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.YUDOFU.get())}));
    public static Supplier<RecipeBookCategories> TF_SEARCH = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_TF_SEARCH", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42522_)}));
    public static Supplier<RecipeBookCategories> TF_MISC = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_TF_MISC", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.TF_CIRCUIT.get())}));
    public static Supplier<RecipeBookCategories> TF_MECHA = Suppliers.memoize(() -> RecipeBookCategories.create((String)"TOFUCRAFT_TF_MECHA", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TofuItems.TF_BATTERY.get())}));

    @SubscribeEvent
    public static void registerRecipeCategories(RegisterRecipeBookCategoriesEvent event) {
        event.registerBookCategories(TofuRecipeBookTypes.WORK_STATION, (List)ImmutableList.of((Object)WORK_STATION_SEARCH.get(), (Object)WORK_STATION_TF_MECH.get()));
        event.registerAggregateCategory(WORK_STATION_SEARCH.get(), (List)ImmutableList.of((Object)WORK_STATION_TF_MECH.get()));
        event.registerRecipeCategoryFinder((RecipeType)TofuRecipes.RECIPETYPE_TOFU_WORK_STATION.get(), recipe -> WORK_STATION_TF_MECH.get());
        event.registerBookCategories(TofuRecipeBookTypes.COOKING, (List)ImmutableList.of((Object)COOKING_SEARCH.get(), (Object)COOKING_MEALS.get(), (Object)COOKING_FAST_FOOD.get(), (Object)COOKING_DRINKS.get(), (Object)COOKING_MISC.get()));
        event.registerAggregateCategory(COOKING_SEARCH.get(), (List)ImmutableList.of((Object)COOKING_MEALS.get(), (Object)COOKING_FAST_FOOD.get(), (Object)COOKING_DRINKS.get(), (Object)COOKING_MISC.get()));
        event.registerRecipeCategoryFinder((RecipeType)TofuRecipes.RECIPETYPE_TOFU_POT.get(), recipe -> {
            TofuPotRecipe cookingRecipe;
            TofuPotCategory tab;
            if (recipe instanceof TofuPotRecipe && (tab = (cookingRecipe = (TofuPotRecipe)recipe).category()) != null) {
                return switch (tab) {
                    default -> throw new IncompatibleClassChangeError();
                    case TofuPotCategory.MEAL -> COOKING_MEALS.get();
                    case TofuPotCategory.DRINK -> COOKING_DRINKS.get();
                    case TofuPotCategory.MISC -> COOKING_MISC.get();
                    case TofuPotCategory.FAST_FOOD -> COOKING_FAST_FOOD.get();
                };
            }
            return COOKING_MISC.get();
        });
        event.registerBookCategories(TofuRecipeBookTypes.TF_CRAFT, (List)ImmutableList.of((Object)TF_SEARCH.get(), (Object)TF_MECHA.get(), (Object)TF_MISC.get()));
        event.registerAggregateCategory(TF_SEARCH.get(), (List)ImmutableList.of((Object)TF_MECHA.get(), (Object)TF_MISC.get()));
        event.registerRecipeCategoryFinder((RecipeType)TofuRecipes.RECIPETYPE_TF_CRAFT.get(), recipe -> {
            TFCraftingRecipe cookingRecipe;
            TFCraftingCategory tab;
            if (recipe instanceof TFCraftingRecipe && (tab = (cookingRecipe = (TFCraftingRecipe)recipe).category()) != null) {
                return switch (tab) {
                    default -> throw new IncompatibleClassChangeError();
                    case TFCraftingCategory.TF_MECHA -> TF_MECHA.get();
                    case TFCraftingCategory.MISC -> TF_MISC.get();
                };
            }
            return TF_MISC.get();
        });
    }
}

