/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.model;

import baguchan.tofucraft.client.animation.definitions.TofuGandlemAnimation;
import baguchan.tofucraft.entity.TofuGandlem;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class TofuGandlemModel<T extends TofuGandlem>
extends HierarchicalModel<T> {
    private final ModelPart baseRoot;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart core;
    private final ModelPart core2;
    private final List<ModelPart> coreModelParts;

    public TofuGandlemModel(ModelPart root) {
        this.baseRoot = root;
        this.root = root.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.core = this.root.m_171324_("core");
        this.core2 = this.root.m_171324_("core2");
        this.coreModelParts = ImmutableList.of((Object)this.core, (Object)this.core2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, 0.0f, -3.0f, 10.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition core2 = root.m_171599_("core2", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition right_hand = root.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-3.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-4.0f, (float)0.0f));
        PartDefinition right_hand2 = right_hand.m_171599_("right_hand2", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-3.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition left_hand = root.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(0.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-4.0f, (float)0.0f));
        PartDefinition left_hand2 = left_hand.m_171599_("left_hand2", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(0.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (((TofuGandlem)((Object)entity)).isSleep()) {
            this.head.f_104203_ = 0.4f;
            this.head.f_104204_ = 0.0f;
        } else {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        }
        this.m_233381_(((TofuGandlem)((Object)entity)).attackAnimationState, TofuGandlemAnimation.ATTACK, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).shootAnimationState, TofuGandlemAnimation.SHOOT, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).shootingAnimationState, TofuGandlemAnimation.SHOOTING, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).rushAnimationState, TofuGandlemAnimation.RUSH, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).idleAnimationState, TofuGandlemAnimation.IDLE, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).deathAnimationState, TofuGandlemAnimation.DEATH, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).chargeAnimationState, TofuGandlemAnimation.CHARGE, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).chargeStopAnimationState, TofuGandlemAnimation.CHARGE_STOP, ageInTicks);
        this.m_233381_(((TofuGandlem)((Object)entity)).chargeFailAnimationState, TofuGandlemAnimation.CHARGE_FAIL, ageInTicks);
    }

    public List<ModelPart> getCoreModelParts() {
        return this.coreModelParts;
    }

    public ModelPart m_142109_() {
        return this.baseRoot;
    }
}

