/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.render.entity;

import baguchan.tofucraft.entity.TofuBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class TofuBoatRenderer
extends EntityRenderer<TofuBoat> {
    private final Map<TofuBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public TofuBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(TofuBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("tofucraft", TofuBoatRenderer.getTextureLocation(type, chest)), (Object)this.createBoatModel(context, (TofuBoat.Type)((Object)type), chest))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, TofuBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? TofuBoatRenderer.createChestBoatModelName(type) : TofuBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.m_174023_(modellayerlocation);
        return chest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static ModelLayerLocation createLocation(String path) {
        return new ModelLayerLocation(new ResourceLocation("tofucraft", path), "main");
    }

    public static ModelLayerLocation createBoatModelName(TofuBoat.Type type) {
        return TofuBoatRenderer.createLocation("boat/" + type.getName());
    }

    public static ModelLayerLocation createChestBoatModelName(TofuBoat.Type type) {
        return TofuBoatRenderer.createLocation("chest_boat/" + type.getName());
    }

    private static String getTextureLocation(TofuBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(TofuBoat boat, float boatYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        float f2;
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.375f, 0.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - boatYaw));
        float f = (float)boat.m_38385_() - partialTicks;
        float f1 = boat.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(partialTicks)), (float)0.0f)) {
            stack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(boat);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel model = (BoatModel)pair.getSecond();
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        model.m_6973_((Boat)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(model.m_103119_(resourcelocation));
        model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_110478_());
            model.m_102282_().m_104301_(stack, vertexconsumer1, light, OverlayTexture.f_118083_);
        }
        stack.m_85849_();
        super.m_7392_((Entity)boat, boatYaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(TofuBoat boat) {
        return (ResourceLocation)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(TofuBoat boat) {
        return this.boatResources.get((Object)boat.getTofuBoatType());
    }
}

