/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.screen;

import baguchan.tofucraft.client.screen.TFCraftingTableRecipeBookComponent;
import baguchan.tofucraft.inventory.TFCraftingTableMenu;
import baguchan.tofucraft.registry.TofuFluids;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;

public class TfCraftingTableScreen
extends AbstractContainerScreen<TFCraftingTableMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("tofucraft", "textures/gui/tf_crafting_table.png");
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private final TFCraftingTableRecipeBookComponent recipeBookComponent = new TFCraftingTableRecipeBookComponent();
    private boolean widthTooNarrow;
    private static final Rectangle PROGRESS_ARROW = new Rectangle(89, 34, 24, 17);

    public TfCraftingTableScreen(TFCraftingTableMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.f_97728_ = 100;
        this.recipeBookComponent.m_100309_(this.f_96543_, this.f_96544_, this.f_96541_, this.widthTooNarrow, (RecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_96544_ / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, p_289630_ -> {
            this.recipeBookComponent.m_100384_();
            this.f_97735_ = this.recipeBookComponent.m_181401_(this.f_96543_, this.f_97726_);
            p_289630_.m_264152_(this.f_97735_ + 5, this.f_96544_ / 2 - 49);
        }));
        this.m_7787_((GuiEventListener)this.recipeBookComponent);
        this.m_264313_((GuiEventListener)this.recipeBookComponent);
        this.f_97728_ = 29;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.recipeBookComponent.m_100386_();
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        if (this.recipeBookComponent.m_100385_() && this.widthTooNarrow) {
            this.recipeBookComponent.m_88315_(gui, mouseX, mouseY, partialTicks);
        } else {
            super.m_88315_(gui, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.m_88315_(gui, mouseX, mouseY, partialTicks);
            this.recipeBookComponent.m_280128_(gui, this.f_97735_, this.f_97736_, false, partialTicks);
        }
        this.recipeBookComponent.m_280545_(gui, this.f_97735_, this.f_97736_, mouseX, mouseY);
        this.m_280072_(gui, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics gui, int mouseX, int mouseY) {
        super.m_280003_(gui, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.f_96541_ == null) {
            return;
        }
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int heightInd = (int)(44.0f * (float)((TFCraftingTableMenu)this.f_97732_).getTFEnergy() / (float)((TFCraftingTableMenu)this.f_97732_).getTFMaxEnergy());
        if (heightInd > 0) {
            TfCraftingTableScreen.renderFluidStack(gui.m_280168_(), this.f_97735_ + 158, this.f_97736_ + 69, 10, heightInd, (Fluid)TofuFluids.SOYMILK.get());
        }
        int l = ((TFCraftingTableMenu)this.f_97732_).getCookProgressionScaled();
        gui.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + TfCraftingTableScreen.PROGRESS_ARROW.x, this.f_97736_ + TfCraftingTableScreen.PROGRESS_ARROW.y, 176, 15, l + 1, TfCraftingTableScreen.PROGRESS_ARROW.height);
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.m_100385_()) && super.m_6774_(x, y, width, height, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
        if (this.recipeBookComponent.m_6375_(mouseX, mouseY, buttonId)) {
            this.m_7522_((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.m_100385_() || super.m_6375_(mouseX, mouseY, buttonId);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int x, int y, int buttonIdx) {
        boolean flag = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + this.f_97726_) || mouseY >= (double)(y + this.f_97727_);
        return flag && this.recipeBookComponent.m_100297_(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, buttonIdx);
    }

    protected void m_6597_(Slot slot, int mouseX, int mouseY, ClickType clickType) {
        super.m_6597_(slot, mouseX, mouseY, clickType);
        this.recipeBookComponent.m_6904_(slot);
    }

    public void m_6916_() {
        this.recipeBookComponent.m_100387_();
    }

    @Nonnull
    public RecipeBookComponent m_5564_() {
        return this.recipeBookComponent;
    }

    public static void renderFluidStack(PoseStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, Fluid fluid) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width == 0) break;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            int shiftedX = x + 16 - maskRight;
            float uLocalDif = uDif * (float)maskRight / 16.0f;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height == 0) continue block0;
                int y = yPosition - (yTile + 1) * 16;
                int maskTop = 16 - height;
                float vLocalDif = vDif * (float)maskTop / 16.0f;
                vertexBuffer.m_252986_(matrix4f, (float)x, (float)(y + 16), 0.0f).m_7421_(uMin + uLocalDif, vMax).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)shiftedX, (float)(y + 16), 0.0f).m_7421_(uMax, vMax).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)shiftedX, (float)(y + maskTop), 0.0f).m_7421_(uMax, vMin + vLocalDif).m_5752_();
                vertexBuffer.m_252986_(matrix4f, (float)x, (float)(y + maskTop), 0.0f).m_7421_(uMin + uLocalDif, vMin + vLocalDif).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexBuffer.m_231175_());
        RenderSystem.disableBlend();
    }
}

