/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.data.recipe.builder;

import baguchan.tofucraft.recipe.TFCraftingCategory;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class TFShapedRecipeBuilder
implements RecipeBuilder {
    private final TFCraftingCategory category;
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private boolean showNotification = true;
    private final int tfNeed;

    public TFShapedRecipeBuilder(TFCraftingCategory p_249996_, ItemLike p_251475_, int p_248948_, int tfNeed) {
        this.category = p_249996_;
        this.result = p_251475_.m_5456_();
        this.count = p_248948_;
        this.tfNeed = tfNeed;
    }

    public static TFShapedRecipeBuilder shaped(TFCraftingCategory p_250853_, ItemLike p_249747_) {
        return TFShapedRecipeBuilder.shaped(p_250853_, p_249747_, 1, 500);
    }

    public static TFShapedRecipeBuilder shaped(TFCraftingCategory p_251325_, ItemLike p_250636_, int p_249081_, int tf) {
        return new TFShapedRecipeBuilder(p_251325_, p_250636_, p_249081_, tf);
    }

    public TFShapedRecipeBuilder define(Character p_206417_, TagKey<Item> p_206418_) {
        return this.define(p_206417_, Ingredient.m_204132_(p_206418_));
    }

    public TFShapedRecipeBuilder define(Character p_126128_, ItemLike p_126129_) {
        return this.define(p_126128_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126129_}));
    }

    public TFShapedRecipeBuilder define(Character p_126125_, Ingredient p_126126_) {
        if (this.key.containsKey(p_126125_)) {
            throw new IllegalArgumentException("Symbol '" + p_126125_ + "' is already defined!");
        }
        if (p_126125_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_126125_, p_126126_);
        return this;
    }

    public TFShapedRecipeBuilder pattern(String p_126131_) {
        if (!this.rows.isEmpty() && p_126131_.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(p_126131_);
        return this;
    }

    public TFShapedRecipeBuilder unlockedBy(String p_126133_, CriterionTriggerInstance p_126134_) {
        this.advancement.m_138386_(p_126133_, p_126134_);
        return this;
    }

    public TFShapedRecipeBuilder group(@Nullable String p_126146_) {
        this.group = p_126146_;
        return this;
    }

    public TFShapedRecipeBuilder showNotification(boolean p_273326_) {
        this.showNotification = p_273326_;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> p_126141_, ResourceLocation p_126142_) {
        this.ensureValid(p_126142_);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126142_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126142_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126141_.accept(new Result(p_126142_, this.result, this.count, this.group == null ? "" : this.group, this.category, this.rows, this.key, this.advancement, p_126142_.m_246208_("recipes/" + this.category.m_7912_() + "/"), this.showNotification, this.tfNeed));
    }

    private void ensureValid(ResourceLocation p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final TFCraftingCategory category;
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean showNotification;
        private final int tfNeed;

        public Result(ResourceLocation p_273548_, Item p_273530_, int p_272738_, String p_273549_, TFCraftingCategory p_273500_, List<String> p_273744_, Map<Character, Ingredient> p_272991_, Advancement.Builder p_273260_, ResourceLocation p_273106_, boolean p_272862_, int tfNeed) {
            this.category = p_273500_;
            this.id = p_273548_;
            this.result = p_273530_;
            this.count = p_272738_;
            this.group = p_273549_;
            this.pattern = p_273744_;
            this.key = p_272991_;
            this.advancement = p_273260_;
            this.advancementId = p_273106_;
            this.showNotification = p_272862_;
            this.tfNeed = tfNeed;
        }

        public void m_7917_(JsonObject p_126167_) {
            p_126167_.addProperty("category", this.category.m_7912_());
            if (!this.group.isEmpty()) {
                p_126167_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            p_126167_.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            p_126167_.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            p_126167_.add("result", (JsonElement)jsonObject);
            p_126167_.addProperty("show_notification", Boolean.valueOf(this.showNotification));
            p_126167_.addProperty("tf", (Number)this.tfNeed);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TofuRecipes.RECIPE_TF_CRAFT_SHAPED.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        public int getTfNeed() {
            return this.tfNeed;
        }
    }
}

